<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Session;

class LocaleServiceProvider extends ServiceProvider
{
    public function register()
    {
        //
    }

    public function boot()
    {
        // Récupérer la langue de la session ou utiliser la langue par défaut
        $locale = Session::get('locale', config('app.locale', 'ar'));

        // S'assurer que la langue est valide
        if (!in_array($locale, ['ar', 'fr'])) {
            $locale = 'ar';
        }

        // Définir la langue
        App::setLocale($locale);
    }
}
