<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\App;

class LanguageServiceProvider extends ServiceProvider
{
    public function register()
    {
        //
    }

    public function boot()
    {
        $locale = Session::get('locale', config('languages.default'));
        
        if (!in_array($locale, config('languages.available'))) {
            $locale = config('languages.default');
        }

        App::setLocale($locale);
        Session::put('locale', $locale);
    }
}
