<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Notifications\Messages\MailMessage;

class SalleSportStatutNotification extends Notification
{
    use Queueable;

    public $type;
    public $dateDebut;
    public $commentaire;

    public function __construct($type, $dateDebut = null, $commentaire = null)
    {
        $this->type = $type;
        $this->dateDebut = $dateDebut;
        $this->commentaire = $commentaire;
    }

    // Les canaux de notification : base de données + mail si besoin
    public function via($notifiable)
    {
        return ['database'];
    }

    // Contenu de la notification pour la base de données
    public function toDatabase($notifiable)
    {
        return [
            'type' => $this->type,
            'message' => $this->type === 'accepte' 
                ? "طلبكم قد تم قبوله. تاريخ بداية النشاط: ".$this->dateDebut->format('d/m/Y')
                : "طلبكم قد تم رفضه . سبب الرفض: ".$this->commentaire,
            'date' => now(),
        ];
    }

    // Optionnel : si tu veux aussi envoyer par mail
    public function toMail($notifiable)
    {
        return (new MailMessage)
                    ->subject('رد على طلبكم المتعلق بإنشاء قاعة الرياضة')
                    ->markdown('emails.salle_sport.statut_mail', [
                        'type' => $this->type,
                        'dateDebut' => $this->dateDebut,
                        'commentaire' => $this->commentaire,
                        'user' => $notifiable,
                    ]);
    }
}
