<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Notifications\Messages\MailMessage;

class FormationStatutNotification extends Notification
{
    use Queueable;

    public $type;
    public $dateDebut;
    public $motif;

    public function __construct($type, $data = null)
    {
        $this->type = $type;
        if($type === 'accepte') $this->dateDebut = $data;
        if($type === 'refuse') $this->motif = $data;
    }

    public function via($notifiable)
    {
        return ['mail', 'database'];
    }

    public function toMail($notifiable)
    {
        if ($this->type === 'accepte') {
            return (new MailMessage)
                ->subject('تم قبول مشروعك')
                ->line('تم قبول مشروعك.');
        } else {
            return (new MailMessage)
                ->subject('تم رفض مشروعك')
                ->line('نأسف، تم رفض مشروعك.')
                ->line('السبب: ' . $this->motif);
        }
    }

    public function toArray($notifiable)
    {
        return [
            'type' => $this->type,
            'motif' => $this->motif,
        ];
    }
}
