<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TpTypeDocument extends Model
{
    use HasFactory;

    // Nom de la table (optionnel si le nom suit la convention)
    protected $table = 'tp_type_document';

    // Clé primaire
    protected $primaryKey = 'id_type_doc';

    // Auto-increment
    public $incrementing = true;

    // Type de clé primaire
    protected $keyType = 'int'; // bigint fonctionne aussi

    // Timestamps (created_at et updated_at)
    public $timestamps = false; // mettre true si la table a ces colonnes

    // Champs remplissables
    protected $fillable = [
        'type_ar',
        'type_fr',
        'type_en'
    ];

   
}
