<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Laravel\Scout\Searchable;

class Section extends Model
{
    use HasFactory, Searchable;

    protected $table = 'sections';
    protected $primaryKey = 'id_S';
    public $timestamps = false;
    public $incrementing = true;

    protected $fillable = [
        'id_P',
        'titre_S',
        'contenue_S',
       'ordre_S',
        
    ];

    public function page()
    {
        return $this->belongsTo(Page::class, 'id_P' , 'id_P');
    }

    public function info_supps()
    {
        return $this->hasMany(Info_supp::class, 'id_S', 'id_S');
    }

       /**
     * Get the indexable data array for the model.
     *
     * @return array
     */
    public function toSearchableArray()
    {
        return [
        'titre_S' => $this->titre_S,
        'contenue_S' => $this->contenue_S,
    ];
    }

    public function utilisateur()
    {
        return $this->belongsTo(Utilisateur::class, 'id_user', 'id_user');
    }

}
