<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Page extends Model
{
    use HasFactory;

    protected $table = 'pages';
    protected $primaryKey = 'id_P';
    public $timestamps = false;
    public $incrementing = true;

    protected $fillable = [
        'id_G',
       
        'titre_P',
        'image_titre',
        'ordre_P',
        'html_content', 
        'css_content'
    ];

    public function guide()
    {
        return $this->belongsTo(Guide::class, 'id_G', 'id_G');
    }

    public function sections()
    {
        return $this->hasMany(Section::class, 'id_P', 'id_P');
    }

    public function info_supps()
    {
        return $this->hasMany(Info_supp::class, 'id_P' , 'id_P');
    }

    
}
