<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class InvestissementSport extends Model
{
    use HasFactory;

    protected $table = 'investissement_sport';
    protected $primaryKey = 'id_inv_sport';
    public $incrementing = true;
    protected $keyType = 'int';
    public $timestamps = true;

    protected $fillable = [
        'id_formulaire',
        'id_statut',
        'type_espace_s_id',
        'nbr_chambre',
        'nbr_stade',
        'nbr_stages_sportifs',
        'nbr_salles',
        'nbr_vestiaire',
        'nbr_salle_renforcement_musculaire',
        'capacite_accueil_foyer',
        'capacite_accueil_stade',
        'heberg_rest',
        'stage_activ',
        'espace_exercice',
        'activite_culturel',
        'manifestation_sportif',
        'autres',
        'autres_services',
        'nom_projet',
        'nature_projet_id',
        'nbr_emplois',
        'directeur_etabl_id',
        'remarques',
        'commentaire_motif'
    ];

    public function formulaire()
    {
        return $this->belongsTo(TypeFormulaire::class, 'id_formulaire', 'id_type');
    }

    public function statut()
    {
        return $this->belongsTo(TpStatut::class, 'id_statut', 'id_statut');
    }

    public function typeEspace()
    {
        return $this->belongsTo(TypeEspaceS::class, 'type_espace_s_id', 'id_type_es');
    }

    public function natureProjet()
    {
        return $this->belongsTo(NatureProjet::class, 'nature_projet_id', 'id_nature_p');
    }

    public function directeur()
    {
        return $this->belongsTo(DirecteurEtablissement::class, 'directeur_etabl_id', 'id_directeur');
    }

        public function investissements()
    {
        return $this->hasMany(Investissement::class, 'id_inv_sport', 'id_inv_sport');
    }

}
