<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Investissement extends Model
{
    use HasFactory;

    // Nom de la table
    protected $table = 'investissement';

    // Clé primaire
    protected $primaryKey = 'id_inv';
    protected $keyType = 'int';

    // PK auto-increment
    public $incrementing = true;
    public $timestamps = false;

    // Colonnes pouvant être assignées en masse
    protected $fillable = [
        'user_id',
        'type_invest_id',
        'secteur_invest_id',
        'montant_inv',
        'source',
        'id_source_financement',
        'montant_fin',
        'remarques',
        'id_projet',
        'id_inst',
        'id_jeune_enfant',
        'id_inv_sport'
    ];


    public function utilisateur()
    {
        return $this->belongsTo(Utilisateur::class, 'user_id', 'id');
    }

    public function typeInvestissement()
    {
        return $this->belongsTo(TypeInvestissement::class, 'type_invest_id', 'id_type_inv');
    }

    public function secteurInvestissement()
    {
        return $this->belongsTo(SecteurFinancement::class, 'secteur_invest_id', 'id_secteur');
    }

    public function sourceFinancement()
    {
        return $this->belongsTo(SourceFinancement::class, 'id_source_financement', 'id_source');
    }

    public function projet()
    {
        return $this->belongsTo(ProjetDivertissementJeuneEnfant::class, 'id_projet', 'id_projet');
    }

    public function institution()
    {
        return $this->belongsTo(InstitutionPriveJeunesse::class, 'id_inst', 'id_inst');
    }

    public function activite()
    {
        return $this->belongsTo(ActiviteJeuneEnfant::class, 'id_jeune_enfant', 'id_jeune_enfant');
    }

    public function formation()
    {
        return $this->belongsTo(InvestissementSport::class, 'id_inv_sport', 'id_inv_sport');
    }

}
