<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DocumentsFinancement extends Model
{
    use HasFactory;

    protected $table = 'documents_financement';

    protected $primaryKey = 'id_doc_fin';

    public $timestamps = true; 

    protected $fillable = [
        'id_doc',
        'file',
        'remarques',
        'id_doc_list',
    ];


    public function typeDocument()
    {
        return $this->belongsTo(TpTypeDocument::class, 'id_doc', 'id_type_doc');
    }

    public function docList()
    {
        return $this->belongsTo(DocumentsFinancementList::class, 'id_doc_list', 'id_doc_list');
    }
}
