<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TropheeSportif extends Model
{
    use HasFactory;

    protected $table = 'trophees_sportifs';
    protected $primaryKey = 'id_sport';

    public $incrementing = true;
    protected $keyType = 'int'; 

    protected $fillable = [
        'date',
        'title',
        'title_fr',
        'title_en',
        'slug',
        'content',
        'resume_ar',
        'content_fr',
        'resume_fr',
        'content_en',
        'resume_en',
        'image',
        'youtube_url',
        'published',
        'id_user',
    ];

    public function utilisateur()
    {
        return $this->belongsTo(Utilisateur::class, 'id_user', 'id');
    }
}
