<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TpAttachement extends Model
{
    use HasFactory;

    protected $table = 'tp_attachement';
    protected $primaryKey = 'id_type';
    public $incrementing = true;
    protected $keyType = 'int';
    
    protected $fillable = [
        'type_ar',
        'type_fr',
        'type_en',
    ];

    public function attachements()
    {
        return $this->hasMany(Attachement::class, 'id_type_attach', 'id_type');
    }

}
