<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Slider extends Model
{
    use HasFactory;

    protected $table = 'sliders';
    protected $primaryKey = 'id_slider';

    protected $fillable = [
        'titre_ar', 'titre_fr', 'titre_en',
        'soustitre_ar', 'soustitre_fr', 'soustitre_en',
        'titre_bouton_ar', 'lien_bouton_ar',
        'titre_bouton_fr', 'lien_bouton_fr',
        'titre_bouton_en', 'lien_bouton_en',
        'titre_bouton2_ar', 'lien_bouton2_ar',
        'titre_bouton2_fr', 'lien_bouton2_fr',
        'titre_bouton2_en', 'lien_bouton2_en',
        'image', 'id_user'
    ];
    

    public function utilisateur()
    {
        return $this->belongsTo(Utilisateur::class, 'id_user');
    }
}
