<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ServiceAuberge extends Model
{
    use HasFactory;

    protected $table = 'service_auberge';

    protected $primaryKey = 'id_service';

    protected $fillable = [
        'nom_ar',
        'nom_fr',
        'nom_en',
        'id_auberge',
    ];

    public function auberge()
    {
        return $this->belongsTo(Auberge::class, 'id_auberge', 'id');
    }
}
