<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Role extends Model
{
    protected $table = 'roles';
    protected $primaryKey = 'id_roles';
    public $incrementing = true;
    protected $keyType = 'int';

    protected $fillable = ['nom_ar','nom_fr','nom_en','guard_name'];

    public function permissions()
    {
        return $this->belongsToMany(Permission::class, 'roles_permissions', 'roles_id', 'perm_id');
    }

    public function utilisateurs()
    {
        return $this->belongsToMany(\App\Models\Utilisateur::class, 'user_roles', 'roles_id', 'user_id');
    }
}
