<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Reservation extends Model
{
    protected $table = 'reservation';

    protected $primaryKey = 'id_reserv';

    public $timestamps = true;

    protected $fillable = [
        'date_arrive',
        'date_depart',
        'date_reserv',
        'chambre_id',
        'user_id',
        'statut_id',
        'id_auberge',
        'commentaire_motif',
        'nbr_f',
        'nbr_h',
        'nbr_personnes',
        'remarque',
        'total_price'
    ];

    public function auberge()
    {
        return $this->belongsTo(Auberge::class, 'id_auberge', 'id');
    }

    public function user()
    {
        return $this->belongsTo(Utilisateur::class, 'user_id', 'id');
    }

    public function chambre()
    {
        return $this->belongsTo(Chambre::class, 'chambre_id', 'id');
    }

    public function statut()
    {
        return $this->belongsTo(TpStatut::class, 'statut_id', 'id_statut');
    }

    public function restaurations()
    {
        return $this->belongsToMany(
            \App\Models\RestaurationAuberge::class,
            'reservation_restauration',
            'reservation_id',   
            'restauration_id'   
        )->withPivot('tarif')->withTimestamps();
    }
}
