<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Projet extends Model
{
    use HasFactory;

    protected $table = 'projet';
    protected $primaryKey = 'id_projet';
    public $timestamps = false;

    protected $fillable = [
        'id_superviseur',
        'id_formulaire',
        'id_demande',
        'nom_projet',
        'justification_realisation',
        'objectives',
        'public',
        'nombre_spectateur',
        'tranch_age_min',
        'tranch_age_max',
        'parties_realisation',
        'resultat_quantitatif',
        'resultat_qualitatif',
        'perspectives',
        'id_user',
    ];

    public function superviseur()
    {
        return $this->belongsTo(Superviseur::class, 'id_superviseur', 'id_sup');
    }

    public function activites()
    {
        return $this->hasMany(ActivitePhase::class, 'id_projet', 'id_projet');
    }

        public function estimationBudget()
    {
        return $this->hasMany(EstimationBudget::class, 'projet_id', 'id_projet');
    }

    public function formulaire()
    {
        return $this->belongsTo(TypeFormulaire::class, 'id_formulaire', 'id_type');
    }

    public function demande()
    {
        return $this->belongsTo(DemandeFinancement::class, 'id_demande', 'id_demande_fin');
    }

    public function documentsFinancement()
    {
        return $this->hasMany(DocumentsFinancementList::class, 'id_projet', 'id_projet');
    }
    
    public function user()
    {
        return $this->belongsTo(Utilisateur::class, 'id_user');
    }

    public function association()
    {
        return $this->hasOneThrough(
            Association::class,
            DemandeFinancement::class,
            'id_demande_fin',    // clé primaire DemandeFinancement
            'id_association',    // clé primaire Association
            'id_demande',        // clé étrangère Projet
            'association_id'     // clé étrangère DemandeFinancement
        );
    }

}
