<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Guide extends Model
{
    use HasFactory;

    protected $table = 'guides';

    protected $primaryKey = 'id_G';

    public $incrementing = true;

    protected $keyType = 'int';

    protected $fillable = [
        'titre_G',
        'titre_fr',
        'titre_en',
        'ordre',
        'type_contenu',
        'id_parent',
        'id_type',
        'type',
        'open_new_tab'
    ];

    

    public function enfants()
    {
        return $this->hasMany(Guide::class, 'id_parent');
    }

    /*public function children()
    {
        return $this->hasMany(Guide::class, 'id_parent', 'id_G')->orderBy('ordre', 'asc');
    }*/

    public function children()
    {
        return $this->hasMany(Guide::class, 'id_parent', 'id_G')
                    ->orderBy('ordre', 'asc');
    }

    /*public function parent()
    {
        return $this->belongsTo(Guide::class, 'id_parent', 'id_G');
    } */


    public function parent()
    {
        return $this->belongsTo(Guide::class, 'id_parent');
    }

   

    public function type()
    {
        return $this->belongsTo(Type::class, 'id_type');
    }
}
