<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class FieldValue extends Model
{
    protected $table = 'field_values';

    // Allow candidate_id to be mass assigned (was previously concours_ext_id)
    protected $fillable = [
        'candidate_id',
        'field_definition_id',
        'value',
    ];

    public $timestamps = true;

    public function definition()
    {
        return $this->belongsTo(FieldDefinition::class, 'field_definition_id', 'id');
    }

    public function candidate()
    {
        return $this->belongsTo(Candidate::class, 'candidate_id', 'id');
    }
}
