<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class FieldFile extends Model
{
    protected $table = 'field_files';

    // Use candidate_id to match controller & FieldValue
    protected $fillable = [
        'candidate_id',
        'field_definition_id',
        'file_path',
        'original_name',
        'mime_type',
        'size',
		'content'
    ];

    public $timestamps = false;

    public function definition()
    {
        return $this->belongsTo(FieldDefinition::class, 'field_definition_id', 'id');
    }

    public function candidate()
    {
        return $this->belongsTo(\App\Models\Candidate::class, 'candidate_id', 'id');
    }
}
