<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class EspaceAuberge extends Model
{
    use HasFactory;

    // Nom de la table (optionnel si Laravel détecte correctement)
    protected $table = 'espace_auberge';

    // Clé primaire (optionnel si c'est id_espace)
    protected $primaryKey = 'id_espace';

    // Les colonnes pouvant être remplies en masse
    protected $fillable = [
        'nom_ar',
        'nom_fr',
        'nom_en',
        'id_auberge',
    ];

    // Relation avec l'auberge
    public function auberge()
    {
        return $this->belongsTo(Auberge::class, 'id_auberge', 'id');
    }
}
