<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class DemandeFinancement extends Model
{
    protected $table = 'demande_financement';
    protected $primaryKey = 'id_demande_fin';
    public $incrementing = true;
    protected $keyType = 'int'; 

    protected $fillable = [
        'association_id',
        'type_financement_id',
        'type_formulaire_id',
        'id_user',
    ];

    public function association()
    {
        return $this->belongsTo(Association::class, 'association_id', 'id_association');
    }

    public function typeFinancement()
    {
        return $this->belongsTo(TypeFinancement::class, 'type_financement_id', 'id_type_fin');
    }

    public function typeFormulaire()
    {
        return $this->belongsTo(TypeFormulaire::class, 'type_formulaire_id', 'id_type');
    }

    public function projets()
    {
        return $this->hasMany(Projet::class, 'id_demande', 'id_demande_fin');
    }

    public function user()
    {
        return $this->belongsTo(Utilisateur::class, 'id_user');
    }

}
