<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ConcoursExt extends Model
{
    protected $table = 'concours_ext';
    protected $fillable = [
        'nom','prenom','cin','date_naissance','tel','email','adresse','gouvernorat','code_postale','etat'
    ];

    public function fieldValues()
    {
        return $this->hasMany(FieldValue::class, 'concours_ext_id', 'id');
    }

    public function files()
    {
        return $this->hasMany(FieldFile::class, 'concours_ext_id', 'id');
    }

    public function optional()
    {
        return $this->hasOne(ConcoursExtOptional::class, 'concours_ext_id', 'id');
    }

    /**
     * Scope: accepted candidates (primaire OR definitif)
     */
    public function scopeAccepted($query)
    {
        return $query->whereIn('etat', ['acceptation_primaire', 'acceptation_definitif']);
    }

    /**
     * Accessor: human-friendly Arabic label for etat
     * Usage in Blade: $model->etat_label
     */
    public function getEtatLabelAttribute()
    {
        return match($this->etat) {
            'refuse' => 'مرفوض',
            'en_cours' => 'قيد الدراسة',
            'acceptation_primaire' => 'قبول أولي',
            'acceptation_definitif' => 'قبول نهائي',
            default => ($this->etat ?: '-'),
        };
    }
}
