<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ChambreTente extends Model
{
    use HasFactory;

    // Si le nom de la table n'est pas la convention (chambre_tentes), précise-le
    protected $table = 'chambre_tente';

    // Clé primaire si ce n'est pas "id"
    protected $primaryKey = 'id_chambre_tente';

    // Les champs qui peuvent être remplis via mass assignment
    protected $fillable = [
        'nbr_chambre_tente',
        'capacite',
        'auberge_id',
        'type_chambre_id',
        'type',
    ];

    // Si tu veux que timestamps soient gérés automatiquement
    public $timestamps = true;

    // Relations (exemple avec auberge)
    public function auberge()
    {
        return $this->belongsTo(Auberge::class, 'auberge_id', 'id');
    }

    public function typeChambre()
    {
        return $this->belongsTo(TypeChambre::class, 'type_chambre_id', 'id');
    }
}
