<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Avis extends Model
{
    protected $table = 'avis';
    protected $primaryKey = 'id_avis';
    public $timestamps = true; // created_at et updated_at existent

    protected $fillable = [
        'note',
        'date_avis',
        'commentaire',
        'auberge_id',
        'user_id',
    ];

    public function auberge()
    {
        return $this->belongsTo(Auberge::class, 'auberge_id', 'id');
    }

    public function user()
    {
        return $this->belongsTo(Utilisateur::class, 'user_id', 'id');
    }
}
