<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Attachement extends Model
{
    use HasFactory;

    protected $table = 'attachements';
    protected $primaryKey = 'id_attach';
    protected $fillable = [
        'id_type_attach',
        'file',
        'id_demande',
    ];

    // Relation avec tp_attachement
    public function type()
    {
        return $this->belongsTo(TpAttachement::class, 'id_type_attach', 'id_type');
    }

    // Relation avec demandes_manifestation
    public function demande()
    {
        return $this->belongsTo(DemandeManifestation::class, 'id_demande', 'id_demande');
    }
}
