<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AssocParticipante extends Model
{
    use HasFactory;

    protected $table = 'assoc_participantes';

    protected $primaryKey = 'id_assoc_p';

    public $incrementing = true;

    protected $keyType = 'int';

    public $timestamps = true;

    protected $fillable = [
        'nom',
        'num_athlete_h',
        'num_athlete_f',
        'escorte',
        'accompagnants',
        'jurie',
        'officiel',
        'invitee',
        'total',
        'event_id',
    ];

    public function evenement()
    {
        return $this->belongsTo(EvenementSportif::class, 'event_id', 'id_even');
    }
}
