<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class SetLocale
{
    public function handle(Request $request, Closure $next)
    {
        // Vérifier d'abord la session
        $locale = $request->session()->get('locale');

        // Si pas de locale en session, vérifier le cookie
        if (!$locale) {
            $locale = $request->cookie('locale');
        }

        // Si toujours pas de locale, utiliser la config
        if (!$locale) {
            $locale = config('app.locale', 'ar');
        }

        // Vérifier que la locale est valide (ajout 'en')
        if (in_array($locale, ['ar', 'fr', 'en'])) {
            app()->setLocale($locale);
            $request->session()->put('locale', $locale);
        }

        return $next($request);
    }
}
