<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class RoleMiddleware
{
    public function handle(Request $request, Closure $next, $roles = null)
    {
        $user = Auth::user();

        if (! $user) {
            return redirect()->route('login');
        }

        // Support "2,3"
        $acceptedRoles = is_string($roles) ? explode(',', $roles) : (array) $roles;

        // si ton user a un champ role_id
        if (isset($user->id_roles) && in_array($user->id_roles, $acceptedRoles)) {
            return $next($request);
        }

        abort(403, '⛔ Accès non autorisé');
    }
}
