<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;

class RedirectIfAuthenticated
{
    public function handle(Request $request, Closure $next, string ...$guards)
    {
        $guards = empty($guards) ? ['web'] : $guards;

        foreach ($guards as $guard) {
            if (Auth::guard($guard)->check()) {
                Log::info('RedirectIfAuthenticated middleware triggered', [
                    'user' => Auth::guard($guard)->user(),
                    'guard' => $guard,
                ]);

                if ($guard === 'admin') {
                    return redirect()->route('admin.dashboard');
                }

                if ($guard === 'web') {
                    return redirect()->route('dashboard');
                }
            }
        }

        return $next($request);
    }
}
