<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Session;

class Localization
{
    public function handle(Request $request, Closure $next)
    {
        // Si une langue est stockée en session, l'utiliser
        if (Session::has('applocale')) {
            App::setLocale(Session::get('applocale'));
        }
        
        return $next($request);
    }
}
