<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Session;

class Language
{
    protected $languages = ['ar', 'fr', 'en'];

    public function handle(Request $request, Closure $next)
    {
        // Récupérer la langue de la session
        $locale = Session::get('locale', config('app.locale'));

        // Vérifier que la langue est valide
        if (!in_array($locale, $this->languages)) {
            $locale = 'ar';
        }

        // Définir la langue
        App::setLocale($locale);

        return $next($request);
    }
}
