<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Auth\Middleware\Authenticate as Middleware;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;

class Authenticate extends Middleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @param  string[]  ...$guards
     * @return mixed
     */
    public function handle($request, Closure $next, ...$guards)
    {
        // Si on utilise le guard admin
        if (in_array('admin', $guards)) {
            $user = Auth::guard('admin')->user();

            // Si pas connecté → redirection login admin
            if (!$user) {
                return redirect()->route('admin.login');
            }

            // Si rôle 2 ou 3 → rediriger vers login front
            if ($user->roles->pluck('id')->intersect([2, 3])->count()) {
                Auth::guard('admin')->logout(); // Déconnecter si par erreur connecté
                return redirect()->route('login');
            }
        }

        // Appeler le handle parent pour gérer l'authentification standard
        return parent::handle($request, $next, ...$guards);
    }

    /**
     * Get the path the user should be redirected to when they are not authenticated.
     */
    protected function redirectTo(Request $request): ?string
    {
        if (!$request->expectsJson()) {
            if ($request->is('admin') || $request->is('admin/*')) {
                return route('admin.login');
            }
            return route('login');
        }
        return null;
    }
}
