<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Section;
use App\Models\Page;
use Illuminate\Support\Facades\Validator;

class SectionController extends Controller
{
    // retourner toutes les sections d'une page
    public function listByPage($id_P)
    {
        $sections = Section::where('id_P', $id_P)->orderBy('ordre_S')->get();
        return response()->json($sections);
    }

    // show single section (incl. contenu_S)
    public function show($id_S)
    {
        $section = Section::findOrFail($id_S);
        return response()->json($section);
    }

    // créer nouvelle section
    public function store(Request $req)
    {
        $v = Validator::make($req->all(), [
            'titre_S' => 'required|string|max:255',
            'id_P' => 'required|integer|exists:pages,id_P',
            'contenue_S' => 'nullable|string',
            'ordre_S' => 'nullable|integer',
        ]);
        if ($v->fails()) return response()->json(['errors'=>$v->errors()], 422);

        $section = Section::create([
            'titre_S' => $req->titre_S,
            'id_P' => $req->id_P,
            'contenue_S' => $req->contenue_S,
            'ordre_S' => $req->ordre_S ?? 0,
        ]);
        return response()->json($section, 201);
    }

    // mettre à jour le HTML de la section (save from grapes)
    public function save(Request $req, $id_S)
    {
        $section = Section::findOrFail($id_S);
        $v = Validator::make($req->all(), [
            'contenue_S' => 'nullable|string',
            'titre_S' => 'nullable|string|max:255',
            'ordre_S' => 'nullable|integer',
        ]);
        if ($v->fails()) return response()->json(['errors'=>$v->errors()], 422);

        $section->contenue_S = $req->contenue_S ?? $section->contenue_S;
        if ($req->has('titre_S')) $section->titre_S = $req->titre_S;
        if ($req->has('ordre_S')) $section->ordre_S = $req->ordre_S;
        $section->save();

        return response()->json($section);
    }
}
