<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\News;
use App\Models\TropheeSportif;
use App\Models\Guide;

class SearchController extends Controller
{
    public function search(Request $request)
    {
        $query = $request->input('q');

        if (!$query) {
            return redirect()->back()->with('error', 'الرجاء إدخال كلمة للبحث.');
        }

        // 🔎 Recherche dans plusieurs tables
        $news = News::where('title', 'like', "%{$query}%")
                    ->orWhere('content', 'like', "%{$query}%")
                    ->get();

        $trophees = TropheeSportif::where('title', 'like', "%{$query}%")
                                  ->orWhere('content', 'like', "%{$query}%")
                                  ->get();

        $guides = Guide::where('titre_G', 'like', "%{$query}%")->get();

        return view('search.results', compact('query', 'news', 'trophees', 'guides'));
    }
}
