<?php

namespace App\Http\Controllers;

use App\Models\Role;
use App\Models\Permission;
use Illuminate\Http\Request;

class RoleController extends Controller
{
    public function index()
    {
        $roles = Role::orderBy('id_roles','desc')->paginate(15);
        return view('BackOffice.role-permission.role.index', compact('roles'));
    }

    public function create()
    {
        return view('BackOffice.role-permission.role.create');
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'nom_ar'=>'required|string|max:100',
            'nom_fr'=>'nullable|string|max:100',
            'nom_en'=>'nullable|string|max:100',
            'guard_name'=>'nullable|string|max:255',
        ]);

        Role::create($data);
        return redirect()->route('roles.index')->with('ok','تم إضافة الدور.');
    }

    public function edit(Role $role)
    {
        return view('BackOffice.role-permission.role.edit', compact('role'));
    }

    public function update(Request $request, Role $role)
    {
        $data = $request->validate([
            'nom_ar'=>'required|string|max:100',
            'nom_fr'=>'nullable|string|max:100',
            'nom_en'=>'nullable|string|max:100',
            'guard_name'=>'nullable|string|max:255',
        ]);

        $role->update($data);
        return redirect()->route('roles.index')->with('ok','تم تحديث الدور.');
    }

    public function destroy(Role $role)
    {
        $role->delete();
        return redirect()->route('roles.index')->with('ok','تم حذف الدور.');
    }

    public function editPermissions(Role $role)
    {
        $permissions = Permission::orderBy('nom_ar')->get();
        $rolePermissions = $role->permissions->pluck('id_perm')->toArray();
        return view('BackOffice.role-permission.role.add-permissions', compact('role','permissions','rolePermissions'));
    }

    public function updatePermissions(Request $request, Role $role)
    {
        $perms = $request->input('permissions', []); // tableau d'id_perm
        $role->permissions()->sync($perms);
        return redirect()->route('roles.index')->with('ok','تم تحديث صلاحيات الدور.');
    }
}
