<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\Auberge;
use App\Models\Reservation;
use Illuminate\Support\Facades\Auth;
use Carbon\Carbon;
use App\Models\RestaurationAuberge;

class ReservationController extends Controller
{
    public function index()
    {
        $userId = Auth::id();

        $reservations = Reservation::with(['auberge', 'statut'])
            ->where('user_id', $userId) 
            ->latest()
            ->paginate(10);
        return view('reservation_auberge.index', compact('reservations'));
    }

    public function create($auberge_id)
    {
        $auberge = Auberge::findOrFail($auberge_id);
        $user = Auth::user();
        $restaurations = RestaurationAuberge::where('auberge_id', $auberge_id)->get();

        return view('reservation_auberge.reservation_form', compact('auberge', 'user', 'restaurations'));
    }

   /* public function store(Request $request)
    {
        $data = $request->validate([
            'id_auberge' => 'required|exists:auberge,id',
            'date_arrive' => 'required|date',
            'date_depart' => 'required|date|after:date_arrive',
            'nbr_personnes' => 'required|integer|min:1',
            'nbr_h' => 'nullable|integer|min:0',
            'nbr_f' => 'nullable|integer|min:0',
            'remarque' => 'nullable|string|max:1000',
            'accept_terms' => 'accepted',

            
        ]);

        $start = Carbon::parse($data['date_arrive']);
        $end = Carbon::parse($data['date_depart']);

        $auberge = Auberge::findOrFail($data['id_auberge']);
        $chambre = $auberge->chambre ?? null; 

        $nbrJours = $start->diffInDays($end);
        $total_price = $auberge->prix_lit * $data['nbr_personnes'] * $nbrJours;

        $reservation = new Reservation;
        $reservation->user_id = Auth::id();
        $reservation->date_arrive = $start->format('Y-m-d');
        $reservation->date_depart = $end->format('Y-m-d');
        $reservation->date_reserv = Carbon::now()->format('Y-m-d');
        $reservation->nbr_personnes = $data['nbr_personnes'];
        $reservation->nbr_h = $data['nbr_h'] ?? 0;
        $reservation->nbr_f = $data['nbr_f'] ?? 0;
        $reservation->id_auberge = $data['id_auberge'];
        $reservation->remarque = $data['remarque'] ?? null;
        $reservation->total_price = $total_price;
        $reservation->statut_id = 2; 
        $reservation->save();
                        
        return redirect()->route('reservation.index')
            ->with('success','تم إنشاء الحجز بنجاح.');
    }*/


     public function store(Request $request)
    {
        $data = $request->validate([
            'id_auberge' => 'required|exists:auberge,id',
            'date_arrive' => 'required|date',
            'date_depart' => 'required|date|after:date_arrive',
            'nbr_personnes' => 'required|integer|min:1',
            'nbr_h' => 'nullable|integer|min:0',
            'nbr_f' => 'nullable|integer|min:0',
            'remarque' => 'nullable|string|max:1000',
            'accept_terms' => 'accepted',
            'restaurations_selected' => 'nullable|array',
            'restaurations_selected.*' => 'integer|exists:restaurations_auberge,id_rest',
        ]);

        $start = Carbon::parse($data['date_arrive']);
        $end = Carbon::parse($data['date_depart']);
        $nbrJours = $start->diffInDays($end);

        $auberge = Auberge::findOrFail($data['id_auberge']);

        // prix de base
        $baseTotal = $auberge->prix_lit * $data['nbr_personnes'] * $nbrJours;

        // récupérer restaurations réelles depuis la BDD (sécurité)
        $restoIds = $data['restaurations_selected'] ?? [];
        $restos = collect();
        $restoTotal = 0.0;
        if (!empty($restoIds)) {
            $restos = RestaurationAuberge::whereIn('id_rest', $restoIds)->get();
            $restoTotal = (float) $restos->sum('tarif');
        }

        $finalTotal = $baseTotal + $restoTotal;

        DB::beginTransaction();
        try {
            $reservation = new Reservation();
            $reservation->user_id = Auth::id();
            $reservation->date_arrive = $start->format('Y-m-d');
            $reservation->date_depart = $end->format('Y-m-d');
            $reservation->date_reserv = Carbon::now()->format('Y-m-d');
            $reservation->nbr_personnes = $data['nbr_personnes'];
            $reservation->nbr_h = $data['nbr_h'] ?? 0;
            $reservation->nbr_f = $data['nbr_f'] ?? 0;
            $reservation->id_auberge = $data['id_auberge'];
            $reservation->remarque = $data['remarque'] ?? null;
            $reservation->total_price = $finalTotal;
            $reservation->statut_id = 2;
            $reservation->save();

            if ($restos->isNotEmpty()) {
                $attachData = [];
                foreach ($restos as $r) {
                    $attachData[$r->id_rest] = ['tarif' => $r->tarif];
                }
                $reservation->restaurations()->attach($attachData);
            }

            DB::commit();

            return redirect()->route('reservation.index')->with('success','تم إنشاء الحجز بنجاح.');
        } catch (\Exception $e) {
            DB::rollBack();
            // Log::error($e->getMessage());
            return back()->withErrors('خطأ أثناء إنشاء الحجز. حاول مرة أخرى.');
        }
    }       

    public function show($id)
{
    $reservation = Reservation::with(['auberge', 'statut', 'user', 'restaurations'])->findOrFail($id);

    if ($reservation->user_id !== Auth::id()) {
        abort(403, 'غير مصرح لك بعرض هذا الحجز');
    }

    // récupérer toutes les restaurations de l'auberge (pour afficher la liste complète)
    $restaurations = RestaurationAuberge::where('auberge_id', $reservation->id_auberge)->get();

    return view('reservation_auberge.show_form_reserv', compact('reservation', 'restaurations'));
}


    public function destroy($id)
    {
        $reservation = Reservation::findOrFail($id);

        if ($reservation->user_id !== Auth::id()) {
            abort(403, 'غير مصرح لك بحذف هذا الحجز');
        }

        $reservation->delete();

        return redirect()->route('reservation.index')
            ->with('success', 'تم حذف الحجز بنجاح.');
    }



}
