<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Utilisateur;

class ProfileController extends Controller
{
    /**
     * Afficher le profil de l'utilisateur
     */
    public function show()
    {
        $user = auth()->user();
        return view('Auth.profil', compact('user'));
    }

    /**
     * Mettre à jour le profil de l'utilisateur
     */
    public function update(Request $request)
    {
        try {
            // Validation des données
            $validated = $request->validate([
                'nom_prenom' => 'required|string|max:255',
                'email' => 'required|email|unique:utilisateur,email,' . auth()->id(),
                'cin' => 'required|string|max:255',
                'date_delivrance_cin' => 'nullable|date',
                'lieu_delivrance_cin' => 'nullable|string|max:255',
                'tel' => 'nullable|string|max:20',
                'adresse' => 'nullable|string'
            ], [
                'required' => 'حقل :attribute مطلوب.',
                'email' => 'يجب أن يكون :attribute عنوان بريد إلكتروني صحيح.',
                'max' => 'يجب ألا يتجاوز :attribute :max حرفًا.',
                'unique' => 'قيمة :attribute مستخدمة بالفعل.',
                'date' => 'يجب أن يكون :attribute تاريخًا صحيحًا.'
            ]);

            // Récupération de l'utilisateur
            $user = auth()->user();
            if (!$user) {
                throw new \Exception('Utilisateur non trouvé');
            }

            // Log des données avant la mise à jour
            \Log::info('Données de mise à jour:', [
                'user_id' => $user->id,
                'data' => $request->all()
            ]);

            // Mise à jour de l'utilisateur
            $updated = $user->update($request->all());

            if (!$updated) {
                throw new \Exception('Erreur lors de la mise à jour');
            }

            return response()->json([
                'status' => 'success',
                'message' => 'تم تحديث المعلومات بنجاح'
            ]);

        } catch (\Illuminate\Validation\ValidationException $e) {
            \Log::error('Erreur de validation:', [
                'errors' => $e->errors(),
                'request' => $request->all()
            ]);
            throw $e;
        } catch (\Exception $e) {
            \Log::error('Erreur lors de la mise à jour du profil:', [
                'error' => $e->getMessage(),
                'trace' => $e->getTraceAsString()
            ]);
            
            return response()->json([
                'status' => 'error',
                'message' => 'حدث خطأ أثناء تحديث المعلومات. يرجى المحاولة مرة أخرى.'
            ], 500);
        }
    }
}
