<?php

namespace App\Http\Controllers;

use App\Models\Permission;
use Illuminate\Http\Request;

class PermissionController extends Controller
{
    public function index()
    {
        $permissions = Permission::orderBy('id_perm','desc')->paginate(20);
        return view('BackOffice.role-permission.permission.index', compact('permissions'));
    }

    public function create()
    {
        return view('BackOffice.role-permission.permission.create');
    }

    public function store(Request $request)
{
    $data = $request->validate([
        'nom_ar' => 'required|string|max:100',
        'nom_fr' => 'required|string|max:100', 
        'nom_en' => 'required|string|max:100',
        'guard_name' => 'nullable|string|max:255',
    ]);

    try {
        $permission = Permission::create($data);
    } catch (\Exception $e) {
        \Log::error('Permission store error: '.$e->getMessage());
        return redirect()->back()->withInput()->with('error', 'خطأ أثناء حفظ الصلاحية: '.$e->getMessage());
    }

    return redirect()->route('permissions.index')->with('ok','تم إضافة الصلاحية.');
}


    public function edit(Permission $permission)
    {
        return view('BackOffice.role-permission.permission.edit', compact('permission'));
    }

    public function update(Request $request, Permission $permission)
    {
        $data = $request->validate([
            'nom_ar'=>'required|string|max:100',
            'nom_fr'=>'nullable|string|max:100',
            'nom_en'=>'nullable|string|max:100',
            'guard_name'=>'nullable|string|max:255',
        ]);
        $permission->update($data);
        return redirect()->route('permissions.index')->with('ok','تم تحديث الصلاحية.');
    }

    public function destroy(Permission $permission)
    {
        $permission->delete();
        return redirect()->route('permissions.index')->with('ok','تم حذف الصلاحية.');
    }
}
