<?php

namespace App\Http\Controllers;

use App\Models\Guide;
use Illuminate\Http\Request;

class MenuController extends Controller
{
    public function header()
    {
        $guides = Guide::with(['pages', 'children.pages'])
            ->whereHas('pages') 
            ->orderBy('ordre')
            ->get();

        $rootGuides = $guides->whereNull('id_parent');

        return view('partials.header', [
            'guides' => $guides,
            'rootGuides' => $rootGuides,
        ]);
    }
}
