<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Session;

class LanguageController extends Controller
{
// app/Http/Controllers/LanguageController.php

public function switchLang($lang)
{
    // liste explicite des locales autorisées
    $allowed = ['ar', 'fr', 'en'];

    if (!in_array($lang, $allowed)) {
        $lang = 'ar';
    }

    // stocker dans les clés utilisées par vos middlewares
    Session::put('applocale', $lang);
    Session::put('locale', $lang);
    App::setLocale($lang);

    return redirect()
        ->back()
        ->withInput()
        ->withCookie(cookie()->forever('locale', $lang));
}

}
