<?php

namespace App\Http\Controllers\Investissement;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\TypeFormulaire;
use App\Models\Identite_personnel;
use App\Models\Utilisateur;
use App\Models\Gouvernorat;
use App\Models\Delegation;
use App\Models\Immobilier;
use App\Models\Type_immobilier;
use App\Models\Usage_immobilier;
use App\Models\TpStatut;
use App\Mail\SalleSportStatutMail;
use Illuminate\Support\Facades\Mail;
use Carbon\Carbon;
use App\Notifications\SalleSportStatutNotification;
use App\Models\DocumentsFormulaire;

class SalleSportController extends Controller
{
    public function getDelegations($gouvernoratId)
    {
        $delegations = Delegation::where('gouver_id', $gouvernoratId)->get();
        return response()->json($delegations);
    }

    //Front
    public function index2()
    {
        $userId = Auth::id();

        $salles = Immobilier::with(['utilisateur', 'statut'])
            ->where('id_type_formulaire', 1)
            ->where('user_id', $userId) 
            ->latest()
            ->paginate(10);
        return view('investissement.gestion_salle_sport.salle_sport.index', compact('salles'));
    }

    public function create3()
    {
        $user = Auth::user();
        $formulaire = TypeFormulaire::find(1);
        $typesIdentite = Identite_personnel::all();
        $gouvernorats = Gouvernorat::all();
        $typesImmobilier = Type_immobilier::all();
        $usagesImmobilier = Usage_immobilier::all();

        return view('investissement.gestion_salle_sport.salle_sport.create', compact('user',
            'formulaire', 'typesIdentite', 'gouvernorats', 'typesImmobilier', 'usagesImmobilier'
        ));
    }

    public function store2(Request $request)
    {
        $request->validate([
            // Immobilier
            'adresse_imm' => 'required|string|max:255',
            'gouvernorat_id' => 'required|exists:tp_gouvernorat,id_gouver',
            'delegation_id' => 'required|exists:tp_delegation,id_delegation',
            'type_imm_id' => 'required|exists:tp_immobilier,id_type',
            'usage_id' => 'required|exists:tp_usage_immobilier,id_usage_imm',
            'superfici_m2' => 'required|integer|min:100',
            'document_propriete' => 'required|file|mimes:pdf,jpg,jpeg,png',
            'salle_exercice' => 'required|in:0,1',
            'nbr_salle_exercice' => 'nullable|integer|min:1|required_if:salle_exercice,1',
            'superface_salle_exercice' => 'nullable|integer|min:1|required_if:salle_exercice,1',
            'piscine' => 'required|in:0,1',
            'nbr_piscine' => 'nullable|integer|min:1|required_if:piscine,1',
            'superface_piscine' => 'nullable|integer|min:1|required_if:piscine,1',
            'vestiaire' => 'required|in:0,1',
            'nbr_vestiaire' => 'nullable|integer|min:1|required_if:vestiaire,1',
            'superface_vestiaire' => 'nullable|integer|min:1|required_if:vestiaire,1',
            'unitaires_sanitaire' => 'required|in:0,1',
            'superface_unitaires_sanitaire' => 'nullable|integer|min:1|required_if:unitaires_sanitaire,1',
            'stockage_conservation' => 'required|in:0,1',
            'superface_stockage_conservation' => 'nullable|integer|min:1|required_if:stockage_conservation,1',
            'espace_exterieur' => 'required|in:0,1',
            'superface_espace_exterieur' => 'nullable|integer|min:1|required_if:espace_exterieur,1',
            'garage' => 'required|in:0,1',
            'superface_garage' => 'nullable|integer|min:1|required_if:garage,1',
            'autres_surfaces' => 'nullable|integer|min:0',
        ]);

        // Upload du document de propriété
        if ($request->hasFile('document_propriete')) {
            $documentPath = $request->file('document_propriete')->store('documents_propriete');
        } else {
            $documentPath = null;
        }

$immobilier = new Immobilier();
        $immobilier->adresse_imm = $request->adresse_imm ?? null;
        $immobilier->gouvernorat_id = $request->gouvernorat_id ?? null;
        $immobilier->delegation_id = $request->delegation_id ?? null;
        $immobilier->type_imm_id = $request->type_imm_id ?? null;
        $immobilier->usage_id = $request->usage_id ?? null;
        $immobilier->superfici_m2 = $request->superfici_m2 ?? null;
        $immobilier->document_propriete = $documentPath;
        $immobilier->id_type_formulaire = 1;
        $immobilier->id_statut = 2;
        $immobilier->salle_exercice = $request->salle_exercice;
        $immobilier->nbr_salle_exercice = $request->nbr_salle_exercice;
        $immobilier->superface_salle_exercice = $request->superface_salle_exercice;
        $immobilier->piscine = $request->piscine;
        $immobilier->nbr_piscine = $request->nbr_piscine;
        $immobilier->superface_piscine = $request->superface_piscine;
        $immobilier->vestiaire = $request->vestiaire;
        $immobilier->nbr_vestiaire = $request->nbr_vestiaire;
        $immobilier->superface_vestiaire = $request->superface_vestiaire;
        $immobilier->unitaires_sanitaire = $request->unitaires_sanitaire;
        $immobilier->superface_unitaires_sanitaire = $request->superface_unitaires_sanitaire;
        $immobilier->stockage_conservation = $request->stockage_conservation;
        $immobilier->superface_stockage_conservation = $request->superface_stockage_conservation;
        $immobilier->espace_exterieur = $request->espace_exterieur;
        $immobilier->superface_espace_exterieur = $request->superface_espace_exterieur;
        $immobilier->garage = $request->garage;
        $immobilier->superface_garage = $request->superface_garage;
        $immobilier->autres_surfaces = $request->autres_surfaces;
        $immobilier->user_id = Auth::id();
        $immobilier->save();

        return redirect()->route('salle-sport.index2')->with('ok', 'تم إنشاء الطلب بنجاح.');
    }

    public function show2($id)
    {
        $immobilier = Immobilier::with('utilisateur')->findOrFail($id);
        $formulaire = TypeFormulaire::find(1);
        $typesIdentite = Identite_personnel::all();
        $gouvernorats = Gouvernorat::all();
        $delegations = Delegation::where('gouver_id', $immobilier->gouvernorat_id)->get();
        $typesImmobilier = Type_immobilier::all();
        $usagesImmobilier = Usage_immobilier::all();
        return view('investissement.gestion_salle_sport.salle_sport.show', compact(
            'immobilier', 'formulaire', 'typesIdentite', 'gouvernorats', 'delegations', 'typesImmobilier', 'usagesImmobilier'
        ));
    }

    public function edit2($id)
    {
        $immobilier = Immobilier::with('utilisateur')->findOrFail($id);
        $formulaire = TypeFormulaire::find(1);
        $typesIdentite = Identite_personnel::all();
        $gouvernorats = Gouvernorat::all();
        $delegations = Delegation::where('gouver_id', $immobilier->gouvernorat_id)->get();
        $typesImmobilier = Type_immobilier::all();
        $usagesImmobilier = Usage_immobilier::all();
        return view('investissement.gestion_salle_sport.salle_sport.edit', compact(
            'immobilier', 'formulaire', 'typesIdentite', 'gouvernorats', 'delegations', 'typesImmobilier', 'usagesImmobilier'
        ));
    }

    public function update2(Request $request, $id)
    {
        $immobilier = Immobilier::with('utilisateur')->findOrFail($id);

        $request->validate([
            // Utilisateur
            'nom_prenom' => 'required|string|max:50',
            'id_type_identite' => 'required|exists:tp_type_identite_pers,id_type',
            'cin' => 'nullable|digits:8|unique:utilisateur,cin,' . $immobilier->utilisateur->id . ',id',
            'passport' => 'nullable|digits:12|unique:utilisateur,passport,' . $immobilier->utilisateur->id . ',id',
            'num_fiscal' => 'nullable|digits:12|unique:utilisateur,num_fiscal,' . $immobilier->utilisateur->id . ',id',
            'tel' => 'required|string|max:12',
            'email' => 'required|email|unique:utilisateur,email,' . $immobilier->utilisateur->id . ',id',
            'adresse' => 'required|string|max:100',

            // Immobilier
            'adresse_imm' => 'required|string|max:100',
            'commentaire_motif' => 'nullable|string|max:255',
            'gouvernorat_id' => 'required|exists:tp_gouvernorat,id_gouver',
            'delegation_id' => 'required|exists:tp_delegation,id_delegation',
            'type_imm_id' => 'required|exists:tp_immobilier,id_type',
            'usage_id' => 'required|exists:tp_usage_immobilier,id_usage_imm',
            'superfici_m2' => 'required|integer|min:100',
            'document_propriete' => 'sometimes|nullable|file|mimes:pdf,jpg,jpeg,png|max:2048',
            'salle_exercice' => 'required|in:0,1',
            'nbr_salle_exercice' => 'nullable|integer|min:1|required_if:salle_exercice,1',
            'superface_salle_exercice' => 'nullable|integer|min:1|required_if:salle_exercice,1',
            'piscine' => 'required|in:0,1',
            'nbr_piscine' => 'nullable|integer|min:1|required_if:piscine,1',
            'superface_piscine' => 'nullable|integer|min:1|required_if:piscine,1',
            'vestiaire' => 'required|in:0,1',
            'nbr_vestiaire' => 'nullable|integer|min:1|required_if:vestiaire,1',
            'superface_vestiaire' => 'nullable|integer|min:1|required_if:vestiaire,1',
            'unitaires_sanitaire' => 'required|in:0,1',
            'superface_unitaires_sanitaire' => 'nullable|integer|min:1|required_if:unitaires_sanitaire,1',
            'stockage_conservation' => 'nullable|integer|in:0,1',
            'superface_stockage_conservation' => 'nullable|integer|min:1|required_if:stockage_conservation,1',
            'espace_exterieur' => 'required|in:0,1',
            'superface_espace_exterieur' => 'nullable|integer|min:1|required_if:espace_exterieur,1',
            'garage' => 'required|in:0,1',
            'superface_garage' => 'nullable|integer|min:1|required_if:garage,1',
            'autres_surfaces' => 'nullable|integer|min:0',
        ]);

        // Update Utilisateur
        $user = $immobilier->utilisateur;
        $user->nom_prenom = $request->nom_prenom;
        $user->id_type_identite = $request->id_type_identite;
        $user->cin = $request->cin;
        $user->passport = $request->passport;
        $user->num_fiscal = $request->num_fiscal;
        $user->tel = $request->tel;
        $user->email = $request->email;
        $user->adresse = $request->adresse;
        $user->save();

        // Upload document si nouveau
        if ($request->hasFile('document_propriete')) {
            $documentPath = $request->file('document_propriete')->store('documents_propriete');
            $immobilier->document_propriete = $documentPath;
        }

        // Update Immobilier
        $immobilier->update([
            'adresse_imm' => $request->input('adresse_imm', $immobilier->adresse_imm),
            'commentaire_motif' => $request->input('commentaire_motif', $immobilier->commentaire_motif),
            'gouvernorat_id' => $request->input('gouvernorat_id', $immobilier->gouvernorat_id),
            'delegation_id' => $request->input('delegation_id', $immobilier->delegation_id),
            'type_imm_id' => $request->input('type_imm_id', $immobilier->type_imm_id),
            'usage_id' => $request->input('usage_id', $immobilier->usage_id),
            'superfici_m2' => $request->input('superfici_m2', $immobilier->superfici_m2),
            'salle_exercice' => $request->input('salle_exercice', $immobilier->salle_exercice),
            'nbr_salle_exercice' => $request->input('nbr_salle_exercice', $immobilier->nbr_salle_exercice),
            'superface_salle_exercice' => $request->input('superface_salle_exercice', $immobilier->superface_salle_exercice),
            'piscine' => $request->input('piscine', $immobilier->piscine),
            'nbr_piscine' => $request->input('nbr_piscine', $immobilier->nbr_piscine),
            'superface_piscine' => $request->input('superface_piscine', $immobilier->superface_piscine),
            'vestiaire' => $request->input('vestiaire', $immobilier->vestiaire),
            'nbr_vestiaire' => $request->input('nbr_vestiaire', $immobilier->nbr_vestiaire),
            'superface_vestiaire' => $request->input('superface_vestiaire', $immobilier->superface_vestiaire),
            'unitaires_sanitaire' => $request->input('unitaires_sanitaire', $immobilier->unitaires_sanitaire),
            'superface_unitaires_sanitaire' => $request->input('superface_unitaires_sanitaire', $immobilier->superface_unitaires_sanitaire),
            'stockage_conservation' => $request->input('stockage_conservation', $immobilier->stockage_conservation),
            'superface_stockage_conservation' => $request->input('superface_stockage_conservation', $immobilier->superface_stockage_conservation),
            'espace_exterieur' => $request->input('espace_exterieur', $immobilier->espace_exterieur),
            'superface_espace_exterieur' => $request->input('superface_espace_exterieur', $immobilier->superface_espace_exterieur),
            'garage' => $request->input('garage', $immobilier->garage),
            'superface_garage' => $request->input('superface_garage', $immobilier->superface_garage),
            'autres_surfaces' => $request->input('autres_surfaces', $immobilier->autres_surfaces),
        ]);

        return redirect()->route('salle-sport.index2')->with('ok', 'تم تعديل الطلب بنجاح.');
    }

    public function toggleStatut2(Request $request, $id)
    {
        $salle = Immobilier::findOrFail($id);
        $salle->id_statut = $request->id_statut;

        if($request->id_statut == 3 && $request->commentaire_motif) {
            $salle->commentaire_motif = $request->commentaire_motif;
        }

        $salle->save();

        return redirect()->back()->with('success', 'تم تغيير حالة الطلب بنجاح!');
    }    

    public function destroy2($id)
    {
        $salle = Immobilier::findOrFail($id);
        if ($salle->document_propriete && file_exists(storage_path('app/' . $salle->document_propriete))) {
            unlink(storage_path('app/' . $salle->document_propriete));
        }
        $salle->delete();
        return redirect()->route('salle-sport.index2')->with('success', 'تم حذف الاستمارة بنجاح.');
    }

/**  Exoneration  */

    public function createExoneration($id_imm)
    {
        $immobilier = Immobilier::findOrFail($id_imm);
        $formulaire = TypeFormulaire::find(22);
        return view('investissement.gestion_salle_sport.exoneration.create', compact('immobilier','formulaire'));
    }

    public function storeExoneration(Request $request, $id_imm)
    {
        $immobilier = Immobilier::findOrFail($id_imm);

        $request->validate([
            'nom_projet'       => 'required|string|max:255',
            'adresse_projet'   => 'required|string|max:255',
            'copie_cahier_des_charges'           => 'nullable|file|mimes:pdf,jpg,jpeg,png',
            'copie_originale'                    => 'nullable|file|mimes:pdf,jpg,jpeg,png',
            'facture'                            => 'nullable|file|mimes:pdf,jpg,jpeg,png',
            'contrat'                            => 'nullable|file|mimes:pdf,jpg,jpeg,png',
            'fichier_arrivage'                   => 'nullable|file|mimes:pdf,jpg,jpeg,png',
            'fichier_colisage'                   => 'nullable|file|mimes:pdf,jpg,jpeg,png',
            'copie_registre_fiscal'              => 'nullable|file|mimes:pdf,jpg,jpeg,png',
            'copie_registre_national_institutions' => 'nullable|file|mimes:pdf,jpg,jpeg,png',
            'copie_certificat_propriete'         => 'nullable|file|mimes:pdf,jpg,jpeg,png',
            'engagement'                         => 'nullable|file|mimes:pdf,jpg,jpeg,png',
            'exemple_projet'                     => 'nullable|file|mimes:pdf,jpg,jpeg,png',
        ]);

        $files = [
                'copie_cahier_des_charges',
                'copie_originale',
                'facture',
                'contrat',
                'fichier_arrivage',
                'fichier_colisage',
                'copie_registre_fiscal',
                'copie_registre_national_institutions',
                'copie_certificat_propriete',
                'engagement',
                'exemple_projet'
            ];

        $fileData = [];
        foreach ($files as $fileField) {
            if ($request->hasFile($fileField)) {
                $originalName = $request->file($fileField)->getClientOriginalName();
                $path = $request->file($fileField)->storeAs('documents/exoneration', $originalName, 'public');
                $fileData[$fileField] = $path;
            }
        }  

        DocumentsFormulaire::create(array_merge($fileData, [
            'id_user' => $immobilier->user_id,
            'id_formulaire' => 22, 
            'id_type_formulaire' => 1,
            'nom_projet' => $request->nom_projet,
            'adresse_projet' => $request->adresse_projet,
            'id_statut' => 2,
            'immobilier_id' => $id_imm,
            'etat_formulaire' => 'remplir',
        ]));
        return redirect()->route('salle-sport.index2')->with('success', 'تم تسجيل المشروع بنجاح');
    }

    public function editExoneration($id)
    {
        $document = DocumentsFormulaire::findOrFail($id);
        $immobilier = $document->immobilier;
        $formulaire = TypeFormulaire::find(22);
        $typesIdentite = Identite_personnel::all();


        return view('investissement.gestion_salle_sport.exoneration.edit', compact('document', 'immobilier', 'formulaire','typesIdentite'));
    }

    public function updateExoneration(Request $request, $id)
    {
        $document = DocumentsFormulaire::findOrFail($id);
        $immobilier = $document->immobilier;

        $request->validate([
            'nom_projet'       => 'required|string|max:255',
            'adresse_projet'   => 'required|string|max:255',
            'copie_cahier_des_charges'           => 'nullable|file|mimes:pdf,jpg,jpeg,png',
            'copie_originale'                    => 'nullable|file|mimes:pdf,jpg,jpeg,png',
            'facture'                            => 'nullable|file|mimes:pdf,jpg,jpeg,png',
            'contrat'                            => 'nullable|file|mimes:pdf,jpg,jpeg,png',
            'fichier_arrivage'                   => 'nullable|file|mimes:pdf,jpg,jpeg,png',
            'fichier_colisage'                   => 'nullable|file|mimes:pdf,jpg,jpeg,png',
            'copie_registre_fiscal'              => 'nullable|file|mimes:pdf,jpg,jpeg,png',
            'copie_registre_national_institutions' => 'nullable|file|mimes:pdf,jpg,jpeg,png',
            'copie_certificat_propriete'         => 'nullable|file|mimes:pdf,jpg,jpeg,png',
            'engagement'                         => 'nullable|file|mimes:pdf,jpg,jpeg,png',
            'exemple_projet'                     => 'nullable|file|mimes:pdf,jpg,jpeg,png',
        ]);

        $files = [
            'copie_cahier_des_charges',
            'copie_originale',
            'facture',
            'contrat',
            'fichier_arrivage',
            'fichier_colisage',
            'copie_registre_fiscal',
            'copie_registre_national_institutions',
            'copie_certificat_propriete',
            'engagement',
            'exemple_projet'
        ];

        foreach ($files as $fileField) {
            if ($request->hasFile($fileField)) {
                $originalName = $request->file($fileField)->getClientOriginalName();
                $path = $request->file($fileField)->storeAs('documents/exoneration', $originalName, 'public');
                $document->$fileField = $path;
            }
        }

        $document->nom_projet = $request->nom_projet;
        $document->adresse_projet = $request->adresse_projet;
        $document->etat_formulaire = 'remplir';
        $document->save();

        return redirect()->route('salle-sport.index2')->with('success', 'تم تعديل مشروع الإعفاء بنجاح');
    }

    public function showExoneration($id)
    {
        $document = DocumentsFormulaire::findOrFail($id);
        $immobilier = $document->immobilier;
        $formulaire = TypeFormulaire::find(22);
        $typesIdentite = Identite_personnel::all();

        return view('investissement.gestion_salle_sport.exoneration.show', compact(
            'document',
            'immobilier',
            'formulaire',
            'typesIdentite'
        ));
    }

}
