<?php
namespace App\Http\Controllers\Investissement;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

use App\Models\DocumentsFormulaire;
use App\Models\Utilisateur;
use App\Models\TypeFormulaire;
use App\Models\Identite_personnel;
use App\Models\TpStatut;

class ExonarationController extends Controller
{
    public function index(Request $request, $id_type_formulaire = null) 
    {
        $userId = Auth::id();

        $documents = DocumentsFormulaire::where('id_user', $userId)
            ->when($id_type_formulaire, function ($query) use ($id_type_formulaire) {
                $query->where('id_type_formulaire', $id_type_formulaire);
            })
            ->with(['utilisateur', 'statut'])
            ->orderByDesc('created_at')
            ->paginate(10);

        $typeFormulaire = null;
        if ($id_type_formulaire) {
            $typeFormulaire = TypeFormulaire::find($id_type_formulaire);
        }

        return view('investissement.gestion_exoneration.index', compact('documents', 'typeFormulaire'));
    }

    public function create(Request $request, $id_type_formulaire = null)
    {
        $immobilier_id = $request->query('immobilier_id');
        $formulaire = TypeFormulaire::find(22);
        $formulaire2 = $id_type_formulaire 
            ? TypeFormulaire::find($id_type_formulaire)
            : null;
        $typesIdentite = Identite_personnel::all();
        return view('investissement.gestion_exoneration.create', compact(
            'formulaire',
            'formulaire2',
            'typesIdentite',
            'id_type_formulaire',
            'immobilier_id'
        ));
    }

    public function store(Request $request)
    {
        DB::beginTransaction();
        try {
            $request->validate([
                // Documents
                'immobilier_id' => 'nullable|exists:immobilier,id_imm',
                'nom_projet'       => 'required|string|max:255',
                'adresse_projet'   => 'required|string|max:255',
                'copie_cahier_des_charges'           => 'nullable|file|mimes:pdf,jpg,jpeg,png',
                'copie_originale'                    => 'nullable|file|mimes:pdf,jpg,jpeg,png',
                'facture'                            => 'nullable|file|mimes:pdf,jpg,jpeg,png',
                'contrat'                            => 'nullable|file|mimes:pdf,jpg,jpeg,png',
                'fichier_arrivage'                   => 'nullable|file|mimes:pdf,jpg,jpeg,png',
                'fichier_colisage'                   => 'nullable|file|mimes:pdf,jpg,jpeg,png',
                'copie_registre_fiscal'              => 'nullable|file|mimes:pdf,jpg,jpeg,png',
                'copie_registre_national_institutions' => 'nullable|file|mimes:pdf,jpg,jpeg,png',
                'copie_certificat_propriete'         => 'nullable|file|mimes:pdf,jpg,jpeg,png',
                'engagement'                         => 'nullable|file|mimes:pdf,jpg,jpeg,png',
                'exemple_projet'                     => 'nullable|file|mimes:pdf,jpg,jpeg,png',
            ]);

            $files = [
                'copie_cahier_des_charges',
                'copie_originale',
                'facture',
                'contrat',
                'fichier_arrivage',
                'fichier_colisage',
                'copie_registre_fiscal',
                'copie_registre_national_institutions',
                'copie_certificat_propriete',
                'engagement',
                'exemple_projet'
            ];

            $fileData = [];
            foreach ($files as $fileField) {
                if ($request->hasFile($fileField)) {
                    $originalName = $request->file($fileField)->getClientOriginalName();
                    $path = $request->file($fileField)->storeAs('documents/exoneration', $originalName, 'public');
                    $fileData[$fileField] = $path;
                }
            }   

            DocumentsFormulaire::create(array_merge($fileData, [
                'id_user' => Auth::id(),
                'id_formulaire'=> $request->id_formulaire,
                'id_type_formulaire' => $request->id_type_formulaire, 
                'nom_projet'   => $request->nom_projet,
                'adresse_projet'=> $request->adresse_projet,
                'id_statut'    => 2,
                'immobilier_id' => $request->immobilier_id,
                'etat_formulaire' => 'remplir',
            ]));

           DB::commit();
            return redirect()->route('exoneration.index', [
                        'id_type_formulaire' => $request->id_type_formulaire
                    ])->with('success', 'تم تسجيل المشروع بنجاح');

            } catch (\Exception $e) {
                DB::rollBack();
                return back()->withErrors(['error' => 'حدث خطأ أثناء التسجيل: '.$e->getMessage()])
                            ->withInput();
        }
    }

    /*public function edit($id)
    {
        $document = DocumentsFormulaire::with('utilisateur')->findOrFail($id);
        $typesIdentite = Identite_personnel::all();
        $formulaire = TypeFormulaire::find($document->id_formulaire);

        return view('investissement.gestion_exoneration.edit', compact(
            'document','typesIdentite','formulaire'
        ));
    }*/

 public function edit($id)
{
    $document = DocumentsFormulaire::with('utilisateur')->findOrFail($id);
    $typesIdentite = Identite_personnel::all();
    $formulaire = TypeFormulaire::find($document->id_formulaire);

    $formulaire2 = $document->id_type_formulaire 
        ? TypeFormulaire::find($document->id_type_formulaire)
        : null;

    // Définir la variable manquante
    $id_type_formulaire = $document->id_type_formulaire;

    return view('investissement.gestion_exoneration.edit', compact(
        'document','typesIdentite','formulaire','formulaire2','id_type_formulaire'
    ));
}



    /*public function update(Request $request, $id)
    {
        DB::beginTransaction();
        try {
            $document = DocumentsFormulaire::with('utilisateur')->findOrFail($id);
            $utilisateur = $document->utilisateur;

            $request->validate([

                // Documents
                'nom_projet'       => 'required|string|max:255',
                'adresse_projet'   => 'required|string|max:255',
                'id_statut'       => 'nullable|integer|in:1,2,3,4,5',
                'commentaire_motif'        => 'nullable|string',
                'commentaire_acceptation'  => 'nullable|string',
                'commentaire_avis'         => 'nullable|string',
                'copie_cahier_des_charges'           => 'nullable|file|mimes:pdf,jpg,jpeg,png',
                'copie_originale'                    => 'nullable|file|mimes:pdf,jpg,jpeg,png',
                'facture'                            => 'nullable|file|mimes:pdf,jpg,jpeg,png',
                'contrat'                            => 'nullable|file|mimes:pdf,jpg,jpeg,png',
                'fichier_arrivage'                   => 'nullable|file|mimes:pdf,jpg,jpeg,png',
                'fichier_colisage'                   => 'nullable|file|mimes:pdf,jpg,jpeg,png',
                'copie_registre_fiscal'              => 'nullable|file|mimes:pdf,jpg,jpeg,png',
                'copie_registre_national_institutions' => 'nullable|file|mimes:pdf,jpg,jpeg,png',
                'copie_certificat_propriete'         => 'nullable|file|mimes:pdf,jpg,jpeg,png',
                'engagement'                         => 'nullable|file|mimes:pdf,jpg,jpeg,png',
                'exemple_projet'                     => 'nullable|file|mimes:pdf,jpg,jpeg,png',
            ]);

            $files = [
                'copie_cahier_des_charges',
                'copie_originale',
                'facture',
                'contrat',
                'fichier_arrivage',
                'fichier_colisage',
                'copie_registre_fiscal',
                'copie_registre_national_institutions',
                'copie_certificat_propriete',
                'engagement',
                'exemple_projet'
            ];

            foreach ($files as $fileField) {
                if ($request->hasFile($fileField)) {
                    $path = $request->file($fileField)->store('documents/exoneration', 'public');
                    $document->$fileField = $path;
                }
            }

            $document->update([
                'nom_projet'    => $request->nom_projet,
                'adresse_projet'=> $request->adresse_projet,
                'id_statut'      => $request->id_statut ?? 2,
                'commentaire_motif'      => $request->commentaire_motif,
                'commentaire_acceptation'=> $request->commentaire_acceptation,
                'commentaire_avis'       => $request->commentaire_avis,
            ]);

            DB::commit();

            return redirect()->route('exoneration.index')
                            ->with('success', 'تم تحديث المشروع بنجاح ');

        } catch (\Exception $e) {
            DB::rollBack();
            return back()->withErrors(['error' => 'حدث خطأ أثناء التحديث: ' . $e->getMessage()])
                        ->withInput();
        }
    }*/

    public function update(Request $request, $id)
    {
        DB::beginTransaction();
        try {
            $userId = Auth::id();
            $request->validate([
                'id_formulaire'   => 'required|integer|exists:tp_type_formulaire,id_type',
                'id_type_formulaire'   => 'nullable|integer|exists:tp_type_formulaire,id_type',
                'nom_projet'      => 'required|string|max:255',
                'adresse_projet'  => 'required|string|max:255',
                'id_statut'       => 'nullable|integer|in:1,2,3,4,5',
                'commentaire_motif'        => 'nullable|string',
                'commentaire_acceptation'  => 'nullable|string',
                'commentaire_avis'         => 'nullable|string',
                'copie_cahier_des_charges'             => 'nullable|file|mimes:pdf,jpg,jpeg,png',
                'copie_originale'                      => 'nullable|file|mimes:pdf,jpg,jpeg,png',
                'facture'                              => 'nullable|file|mimes:pdf,jpg,jpeg,png',
                'contrat'                              => 'nullable|file|mimes:pdf,jpg,jpeg,png',
                'fichier_arrivage'                     => 'nullable|file|mimes:pdf,jpg,jpeg,png',
                'fichier_colisage'                     => 'nullable|file|mimes:pdf,jpg,jpeg,png',
                'copie_registre_fiscal'                => 'nullable|file|mimes:pdf,jpg,jpeg,png',
                'copie_registre_national_institutions' => 'nullable|file|mimes:pdf,jpg,jpeg,png',
                'copie_certificat_propriete'           => 'nullable|file|mimes:pdf,jpg,jpeg,png',
                'engagement'                           => 'nullable|file|mimes:pdf,jpg,jpeg,png',
                'exemple_projet'                       => 'nullable|file|mimes:pdf,jpg,jpeg,png',
            ]);

            $document = DocumentsFormulaire::with('utilisateur')->findOrFail($id);

            $fileFields = [
                'copie_cahier_des_charges',
                'copie_originale',
                'facture',
                'contrat',
                'fichier_arrivage',
                'fichier_colisage',
                'copie_registre_fiscal',
                'copie_registre_national_institutions',
                'copie_certificat_propriete',
                'engagement',
                'exemple_projet'
            ];

            foreach ($fileFields as $field) {
                if ($request->hasFile($field)) {
                    $originalName = $request->file($field)->getClientOriginalName();
                    $path = $request->file($field)->storeAs('documents/exoneration', $originalName, 'public');
                    $document->$field = $path;
                }
            }

            $document->update([
                'id_user'        => $userId,
                'id_formulaire'  => $request->id_formulaire,
                'id_type_formulaire'=> $request->id_type_formulaire,
                'nom_projet'     => $request->nom_projet,
                'adresse_projet' => $request->adresse_projet,
                'id_statut'      => $request->id_statut ?? 2,
                'commentaire_motif'        => $request->commentaire_motif,
                'commentaire_acceptation'  => $request->commentaire_acceptation,
                'commentaire_avis'         => $request->commentaire_avis,
            ]);

            DB::commit();

             return redirect()->route('exoneration.index', [
                        'id_type_formulaire' => $request->id_type_formulaire
                    ])->with('success', ' تم تحديث المشروع بنجاح');

        } catch (\Exception $e) {
            DB::rollBack();
            return back()->withErrors([
                'error' => "خطأ أثناء التحديث : " . $e->getMessage()
            ])->withInput();
        }
    }


    public function show($id)
    {
        $document = DocumentsFormulaire::with('utilisateur')->findOrFail($id);
        $formulaire = TypeFormulaire::find($document->id_formulaire);
        $id_type_formulaire = $document->id_type_formulaire; // <- récupéré depuis le document

        return view('investissement.gestion_exoneration.show', compact('document','formulaire','id_type_formulaire'));
    }



    /*public function destroy($id)
    {
        DB::beginTransaction();
        try {
            $document = DocumentsFormulaire::findOrFail($id);

            $files = [
                'copie_cahier_des_charges','copie_originale','facture','contrat','fichier_arrivage','fichier_colisage',
                'copie_registre_fiscal','copie_registre_national_institutions','copie_certificat_propriete','engagement','exemple_projet'
            ];

            foreach ($files as $file) {
                if (!empty($document->$file) && \Storage::disk('public')->exists($document->$file)) {
                    \Storage::disk('public')->delete($document->$file);
                }
            }

            $document->utilisateur()->delete();

            $document->delete();

            DB::commit();
             return redirect()->route('exoneration.index', [
                        'id_type_formulaire' => $request->id_type_formulaire
                    ])->with('success', 'تم حذف المشروع بنجاح');
        } catch (\Exception $e) {
            DB::rollBack();
            return back()->withErrors(['error' => 'حدث خطأ أثناء الحذف: '.$e->getMessage()]);
        }
    }*/

    public function destroy(Request $request, $id)
{
    DB::beginTransaction();
    try {
        $document = DocumentsFormulaire::findOrFail($id);

        $files = [
            'copie_cahier_des_charges','copie_originale','facture','contrat','fichier_arrivage','fichier_colisage',
            'copie_registre_fiscal','copie_registre_national_institutions','copie_certificat_propriete','engagement','exemple_projet'
        ];

        // Supprimer les fichiers liés
        foreach ($files as $file) {
            if (!empty($document->$file) && \Storage::disk('public')->exists($document->$file)) {
                \Storage::disk('public')->delete($document->$file);
            }
        }

        // Supprimer l'utilisateur si nécessaire
        // $document->utilisateur()->delete(); // à commenter si l'utilisateur peut avoir plusieurs documents

        $document->delete();

        DB::commit();

        // Redirection avec id_type_formulaire
        $idTypeFormulaire = $request->id_type_formulaire ?? $document->id_type_formulaire;

        return redirect()->route('exoneration.index', [
                    'id_type_formulaire' => $idTypeFormulaire
                ])->with('success', 'تم حذف المشروع بنجاح');

    } catch (\Exception $e) {
        DB::rollBack();
        return back()->withErrors(['error' => 'حدث خطأ أثناء الحذف: '.$e->getMessage()]);
    }
}



    public function toggleStatut(Request $request, $id)
    {
        $request->validate([
            'id_statut' => 'required|integer|in:1,3,4,5',
            'commentaire_motif' => 'nullable|string',
            'commentaire_acceptation' => 'nullable|string',
            'commentaire_avis' => 'nullable|string',
        ]);

        DB::beginTransaction();
        try {
            $document = DocumentsFormulaire::findOrFail($id);

            $document->id_statut = $request->id_statut;

            if ($request->id_statut == 3) {
                $document->commentaire_motif = $request->commentaire_motif;
                $document->commentaire_acceptation = null;
                $document->commentaire_avis = null;
            } elseif ($request->id_statut == 4) {
                $document->commentaire_acceptation = $request->commentaire_acceptation;
                $document->commentaire_motif = null;
                $document->commentaire_avis = null;
            } elseif ($request->id_statut == 5) {
                $document->commentaire_avis = $request->commentaire_avis;
                $document->commentaire_motif = null;
                $document->commentaire_acceptation = null;
            } else {
                $document->commentaire_motif = null;
                $document->commentaire_acceptation = null;
                $document->commentaire_avis = null;
            }

            $document->save();
            DB::commit();

            return redirect()->back()->with('success', 'تم تغيير الوضعية بنجاح');

        } catch (\Exception $e) {
            DB::rollBack();
            return back()->withErrors(['error' => 'حدث خطأ أثناء تغيير الوضعية: '.$e->getMessage()]);
        }
    }


}
