<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\Auth;
use App\Models\Utilisateur;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Hash;
use App\Models\Role;
use App\Models\Type;
use App\Models\News;
use Carbon\Carbon;
use App\Models\Guide;
use App\Models\TropheeSportif;
use App\Models\Slider;

class HomeController extends Controller
{
    public function index(Request $request)
    {
        $guidesPrincipaux = Guide::with(['children' => function($q) {
            $q->orderBy('ordre');
        }])
        ->where('type', 'menu_principal')
        ->whereNull('id_parent')
        ->orderBy('ordre')
        ->get();

        $news = News::where('published', 1)
                    ->orderByDesc('date')
                    ->take(4)
                    ->get();

        $trophee_sportif = TropheeSportif::where('published', 1)
                    ->orderByDesc('date')
                    ->take(3)
                    ->get();

        $sliders = Slider::orderByDesc('id_slider')->get();

        $title = $request->query('title', '');

        return view('home', compact('guidesPrincipaux', 'title', 'news', 'trophee_sportif', 'sliders'));
    }


    public function redirectToForm($formulaire)
    {
        if (!Auth::check()) {
            return redirect()->route('login')->with('error', 'الرجاء تسجيل الدخول للمتابعة.');
        }

        $user = Auth::user();
        if (!in_array($user->role_id, [1, 3])) {
            abort(403, 'غير مسموح لك بالولوج إلى هذا القسم');
        }

        switch ($formulaire) {
            case 'salle-sport':
                return redirect()->route('salle-sport.index2');
            default:
                abort(404);
        }
    }

    public function trophees()
    {
        $trophee_sportif = TropheeSportif::where('published', 1)
            ->orderByDesc('date')
            ->paginate(9); 

        return view('trophees_sport.index', compact('trophee_sportif'));
    }

    public function showTrophee($slug)
    {
        $trophee = TropheeSportif::where('slug', $slug)
            ->where('published', 1)
            ->firstOrFail();

        return view('trophees_sport.show', compact('trophee'));
    }


        public function news()
    {
        $news = News::where('published', 1)
            ->orderByDesc('date')
            ->paginate(9); 

        return view('news.index', compact('news'));
    }

    public function showNews($slug)
    {
        $news = News::where('slug', $slug)
            ->where('published', 1)
            ->firstOrFail();

        return view('news.show', compact('news'));
    }

public function search(Request $request)
    {
        $query = $request->input('q');

        if (!$query) {
            return redirect()->back()->with('error', 'الرجاء إدخال كلمة للبحث.');
        }

        $news = News::where('title', 'like', "%{$query}%")
                    ->orWhere('content', 'like', "%{$query}%")
                    ->get();

        $trophees = TropheeSportif::where('title', 'like', "%{$query}%")
                                  ->orWhere('content', 'like', "%{$query}%")
                                  ->get();

        $guides = Guide::where('titre_G', 'like', "%{$query}%")->get();

        $sliders = Slider::orderByDesc('id_slider')->get();
        return view('search.results', compact('query', 'news', 'trophees', 'guides','sliders'));
    }


    public function redirectGuide($id)
    {
        $guide = Guide::findOrFail($id);

        switch ($guide->type_contenu) {
            case 'lien':
                if (filter_var($guide->lien, FILTER_VALIDATE_URL)) {
                    return redirect()->away($guide->lien);
                }
                return redirect($guide->lien);

            case 'builder':
                if ($guide->id_builder) {
                    return redirect()->route('page.builder.show', ['id' => $guide->id_builder]);
                }
                return redirect()->route('home');

            case 'none':
            default:
                return redirect()->route('home');
        }
    }



}