<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Guide;
use App\Models\Type;

class GuideController extends Controller
{
    public function index($tp)
    {
        $guides = Guide::with('language', 'type_G')->where('id_type', $tp)->get();
        return view('BackOfficeAR.gestion_guide.listeguides' , compact('tp', 'guides'));
    }
    
    public function ajouterGuideform($tp)
    {
        $langues = Language::all();
        return view('BackOfficeAR.gestion_guide.add-guide',compact('langues', 'tp'));
    }

    public function ajouterGuide(Request $request)
    {
       $validatedData = $request->validate([
        'titre' => 'required|string|max:255',
        'ordre' => 'required|integer',
        'langue_id' => 'required|exists:language,id_L',
        'tp' => 'required',

        ]);


        $guide = new Guide([
            'titre_G' => $request->titre,
            'order' => $request->ordre,
            'id_L' => $request->langue_id,
            'id_type'=> $request->tp,
        ]);
        $guide->save();


        return redirect()->route('guides.index', ['tp' => $request->tp])->with('success', 'Guide ajoute avec succès');
    }

}



