<?php

namespace App\Http\Controllers;

use App\Models\Page;
use Illuminate\Http\Request;

class GuideController extends Controller
{
    public function showPage($id_P)
    {
        $page = Page::with(['sections', 'guide'])->findOrFail($id_P);

        return view('front.guide-page', compact('page'));
    }
}



/************************************************************************** */


<?php

namespace App\Http\Controllers;

use App\Models\Guide;
use App\Models\Language;
use App\Models\Page;
use App\Models\Section;
use App\Models\Info_supp;
use App\Models\Type;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Http;


class GuideController extends Controller
{
    //type
    public function dash()
    {
        Log::info('Accessing /dash route', [
            'user' => Auth::user(),
            'authenticated' => Auth::check()
        ]);

        $types_G = Type_G::all();
        return view('BackOfficeAR.dashboardAR', compact('types_G'));
    }


    // liste des guides
    public function index($tp)
    {
        $guides = Guide::with('language', 'type_G')->where('id_type', $tp)->get();
        return view('BackOfficeAR.gestion_guide.listeguides' , compact('tp', 'guides'));
    }
    //liste des page d'un guide
    public function listepages($id)
    {

        $guide = Guide::with('pages')->findOrFail($id);
        return view('BackOfficeAR.gestion_guide.listepages', compact('guide'));
    }
    //liste des section
    public function listesections($id)
    {

        $page = Page::with('sections', 'guide')->findOrFail($id);
        return view('BackOfficeAR.gestion_guide.listesections', compact('page'));
    }


    //liste des Info_supp
    public function listesinfosuppsG($id)
    {

        $ob = Guide::with('info_supps')->findOrFail($id);
        $id_ob = $ob->id_G;
        $nbtype = 0;
        return view('BackOfficeAR.gestion_guide.listeinfosupps', compact('ob' , 'id_ob', 'nbtype'));
    }
    public function listesinfosuppsP($id)
    {

        $ob = Page::with('info_supps')->findOrFail($id);
        $id_ob = $ob->id_P;
        $nbtype = 1;
        return view('BackOfficeAR.gestion_guide.listeinfosupps', compact('ob', 'id_ob' , 'nbtype'));
    }
    public function listesinfosuppsS($id)
    {

        $ob = Section::with('info_supps')->findOrFail($id);
        $id_ob = $ob->id_S;
        $nbtype = 2;
        return view('BackOfficeAR.gestion_guide.listeinfosupps', compact('ob', 'id_ob', 'nbtype'));
    }



    //-----------------------------------------------------------------------------------------------------------


    // affichge form add


    //guide
    public function ajouterGuideform($tp)
    {
        $langues = Language::all();
        return view('BackOfficeAR.gestion_guide.add-guide',compact('langues', 'tp'));
    }

    //page
    public function ajoutePageform($id)
    {
        $guide = Guide::findOrFail($id);
        return view('BackOfficeAR.gestion_guide.add-page', compact('guide'));
    }
    //section
    public function ajouteSectionform($id)
    {
        $page = Page::findOrFail($id);
        return view('BackOfficeAR.gestion_guide.add-section', compact('page'));
    }
    //INFOSUPP
    public function ajoutinfosuppform($id , $nbtype)
    {
        if ($nbtype == 1) {
            $ob = Page::findOrFail($id);
            $id_ob = $ob->id_P;
        } elseif ($nbtype == 2) {
            $ob = Section::findOrFail($id);
            $id_ob = $ob->id_S;
        } else {
            return redirect()->back()->withErrors(['Invalid type specified.']);
        }
        return view('BackOfficeAR.gestion_guide.add-infosupp', compact('ob', 'id_ob', 'nbtype'));
    }



    //-----------------------------------------------------------------------------------------------------------

    //ajout guide
    public function ajouterGuide(Request $request)
    {
$recaptcha = $request->input('g-recaptcha-response');
              if (!$recaptcha) {
                  return redirect()->back()
                      ->with('error', 'يرجى تأكيد أنك لست روبوتًا');
              }
              try {
                  $url = "https://www.google.com/recaptcha/api/siteverify";
                  $response = Http::asForm()->timeout(10)->post($url, [
                      'secret' => config('services.recaptcha.secret_key'),
                      'response' => $recaptcha,
                      'remoteip' => $request->ip(),
                  ]);
          
                  $result = $response->json();
                  if (!$response->successful() || empty($result['success']) || !$result['success']) {
                      return redirect()->back()
                          ->with('error', 'Le reCAPTCHA n\'a pas été validé.');
                  }
              } catch (\Exception $e) {
                  return redirect()->back()
                      ->with('error', 'يرجى تأكيد أنك لست روبوتًا');
              }

       $validatedData = $request->validate([
        'titre' => 'required|string|max:255',
        'ordre' => 'required|integer',
        'langue_id' => 'required|exists:language,id_L',
        'tp' => 'required',

        ]);


        $guide = new Guide([
            'titre_G' => $request->titre,
            'order' => $request->ordre,
            'id_L' => $request->langue_id,
            'id_type'=> $request->tp,
        ]);
        $guide->save();


        return redirect()->route('guides.index', ['tp' => $request->tp])->with('success', 'Guide ajoute avec succès');
    }


    //ajout page
    public function ajouterPage(Request $request)
    {
$recaptcha = $request->input('g-recaptcha-response');
              if (!$recaptcha) {
                  return redirect()->back()
                      ->with('error', 'يرجى تأكيد أنك لست روبوتًا');
              }
              try {
                  $url = "https://www.google.com/recaptcha/api/siteverify";
                  $response = Http::asForm()->timeout(10)->post($url, [
                      'secret' => config('services.recaptcha.secret_key'),
                      'response' => $recaptcha,
                      'remoteip' => $request->ip(),
                  ]);
          
                  $result = $response->json();
                  if (!$response->successful() || empty($result['success']) || !$result['success']) {
                      return redirect()->back()
                          ->with('error', 'Le reCAPTCHA n\'a pas été validé.');
                  }
              } catch (\Exception $e) {
                  return redirect()->back()
                      ->with('error', 'يرجى تأكيد أنك لست روبوتًا');
              }

        $request->validate([
            'titre' => 'required|string|max:255',
            'ordre' => 'required|integer',
            'guide_id' => 'required|exists:guides,id_G',
            'image_titre.*' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048'
        ]);


        $page = new Page([
            'titre_P' => $request->titre,
            'ordre_P' => $request->ordre,
            'id_G' => $request->guide_id,
        ]);
        if ($request->hasFile('image_titre')) {
            $imageTitre = $request->file('image_titre');
            $fileName = time() . '_' . $imageTitre->getClientOriginalName();
            $destinationPath = 'uploads';
            $imageTitre->move($destinationPath , $fileName);
            $page->image_titre=$fileName;
        }
        $page->save();
        return redirect()->route('guides.listepages', ['id' => $request->guide_id])->with('success', 'Page et sections ajoutées avec succès');
    }


    // ajout section
    public function ajouterSection(Request $request)
{
$recaptcha = $request->input('g-recaptcha-response');
              if (!$recaptcha) {
                  return redirect()->back()
                      ->with('error', 'يرجى تأكيد أنك لست روبوتًا');
              }
              try {
                  $url = "https://www.google.com/recaptcha/api/siteverify";
                  $response = Http::asForm()->timeout(10)->post($url, [
                      'secret' => config('services.recaptcha.secret_key'),
                      'response' => $recaptcha,
                      'remoteip' => $request->ip(),
                  ]);
          
                  $result = $response->json();
                  if (!$response->successful() || empty($result['success']) || !$result['success']) {
                      return redirect()->back()
                          ->with('error', 'Le reCAPTCHA n\'a pas été validé.');
                  }
              } catch (\Exception $e) {
                  return redirect()->back()
                      ->with('error', 'يرجى تأكيد أنك لست روبوتًا');
              }

    // Validation des données du formulaire
    $request->validate([
        'titre' => 'required|string|max:255',
        'ordre' => 'required|integer',
        'contenu' => 'required|string',
    ]);
    try {
        $section = new Section([
            'titre_S' => $request->titre,
            'ordre_S' => $request->ordre,
            'contenue_S' => $request->contenu,
            'id_P' => $request->page_id,
        ]);
        $section->save();
        return redirect()->route('pages.listesections', ['id' => $request->page_id])
            ->with('success', 'Section ajoutée avec succès');
    } catch (\Exception $e) {
        Log::error('Error adding section: ', ['exception' => $e->getMessage()]);
        return redirect()->back()->withErrors(['error' => 'Error adding section. Please try again.']);
    }
}

    //ajout infosupp
    public function ajouterinfosupp(Request $request)
    {
$recaptcha = $request->input('g-recaptcha-response');
              if (!$recaptcha) {
                  return redirect()->back()
                      ->with('error', 'يرجى تأكيد أنك لست روبوتًا');
              }
              try {
                  $url = "https://www.google.com/recaptcha/api/siteverify";
                  $response = Http::asForm()->timeout(10)->post($url, [
                      'secret' => config('services.recaptcha.secret_key'),
                      'response' => $recaptcha,
                      'remoteip' => $request->ip(),
                  ]);
          
                  $result = $response->json();
                  if (!$response->successful() || empty($result['success']) || !$result['success']) {
                      return redirect()->back()
                          ->with('error', 'Le reCAPTCHA n\'a pas été validé.');
                  }
              } catch (\Exception $e) {
                  return redirect()->back()
                      ->with('error', 'يرجى تأكيد أنك لست روبوتًا');
              }

        $request->validate([

            'ordre' => 'required|integer',
            'id_ob' => 'required|integer',
            'nbtype' => 'required|integer',
            'link' => 'nullable|string|max:255',
            'images.*' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048',
            'pdf' => 'nullable|file|mimes:jpg,jpeg,png,pdf,doc,docx,zip',

        ]);

        $infosupp = new Info_supp();
        $infosupp->ordre_I = $request->ordre;

        if ($request->nbtype == 1) {
            $infosupp->id_P = $request->id_ob;
        } elseif ($request->nbtype == 2) {
            $infosupp->id_S = $request->id_ob;
        }

        // link
        if ($request->filled('link')) {
            $infosupp->link = $request->link;

        }

        // image
        if ($request->hasFile('images')) {
            $images = $request->file('images');
            $image = $images[0];
            $fileName = time() . '_' . $image->getClientOriginalName();
            $destinationPath = 'uploads';
            $image->move($destinationPath , $fileName);
            $infosupp->image = $fileName;

        }
        
        /*
        if ($request->hasFile('pdf_fr')) {
            $pdf_frTitre = $request->file('pdf_fr');
            $pdf_frName = time() . '_' . $pdf_frTitre->getClientOriginalName();
            $destinationPath = 'uploads';
            $pdf_frTitre->move($destinationPath , $pdf_frName);          
            $infosupp->pdf_fr=$pdf_frName;
        }*/

        if ($request->nbtype == 1) {

            $infosupp->save();
            return redirect()->route('listesinfosuppsP', ['id' => $request->id_ob])->with('success', 'InfoSupp ajoutée avec succès');
        } elseif ($request->nbtype == 2) {

            //pdf
            if ($request->hasFile('pdf')) {
                $pdfTitre = $request->file('pdf');
                $pdfName = time() . '_' . $pdfTitre->getClientOriginalName();
                $destinationPath = 'uploads';
                $pdfTitre->move($destinationPath , $pdfName);
                $infosupp->pdf=$pdfName;
            }
            $infosupp->save();
            return redirect()->route('listesinfosuppsS', ['id' => $request->id_ob])->with('success', 'InfoSupp ajoutée avec succès');
        }

    }




    //-----------------------------------------------------------------------------------------------------------

    // form edit

    public function editGuide($id)
    {
        $guide = Guide::findOrFail($id);
        return view('BackOfficeAR.gestion_guide.editGuide',compact('guide'));
    }
    public function editPage($id)
    {
        $page = Page::with('sections', 'guide')->findOrFail($id);
        return view('BackOfficeAR.gestion_guide.editPage', compact('page'));
    }
    public function editSection($id)
    {
        $section = Section::with('page')->findOrFail($id);
        return view('BackOfficeAR.gestion_guide.editSection', compact('section'));
    }
    public function editInfoSupp($id , $nbtype)
    {
        if ($nbtype == 1) {
            $infosupp = Info_supp::with('page')->findOrFail($id);
        } elseif ($nbtype == 2) {
            $infosupp = Info_supp::with('section')->findOrFail($id);
        }
        return view('BackOfficeAR.gestion_guide.editInfoSupp', compact('infosupp', 'nbtype'));
    }






    //-----------------------------------------------------------------------------------------------------------

    public function updateGuide(Request $request, $id)
    {
$recaptcha = $request->input('g-recaptcha-response');
              if (!$recaptcha) {
                  return redirect()->back()
                      ->with('error', 'يرجى تأكيد أنك لست روبوتًا');
              }
              try {
                  $url = "https://www.google.com/recaptcha/api/siteverify";
                  $response = Http::asForm()->timeout(10)->post($url, [
                      'secret' => config('services.recaptcha.secret_key'),
                      'response' => $recaptcha,
                      'remoteip' => $request->ip(),
                  ]);
          
                  $result = $response->json();
                  if (!$response->successful() || empty($result['success']) || !$result['success']) {
                      return redirect()->back()
                          ->with('error', 'Le reCAPTCHA n\'a pas été validé.');
                  }
              } catch (\Exception $e) {
                  return redirect()->back()
                      ->with('error', 'يرجى تأكيد أنك لست روبوتًا');
              }

        $request->validate([
            'titre_G' => 'required|string|max:255',
            'ordre_G' => 'required|integer',
        ]);

        $guide = Guide::findOrFail($id);
        $guide->titre_G = $request->titre_G;
        $guide->order = $request->ordre_G;
        $guide->save();

        return redirect()->route('guides.index' , ['tp' => $guide->id_type])->with('success', 'Guide mis à jour avec succès');
    }

    public function updatePage(Request $request, $id )
    {

$recaptcha = $request->input('g-recaptcha-response');
              if (!$recaptcha) {
                  return redirect()->back()
                      ->with('error', 'يرجى تأكيد أنك لست روبوتًا');
              }
              try {
                  $url = "https://www.google.com/recaptcha/api/siteverify";
                  $response = Http::asForm()->timeout(10)->post($url, [
                      'secret' => config('services.recaptcha.secret_key'),
                      'response' => $recaptcha,
                      'remoteip' => $request->ip(),
                  ]);
          
                  $result = $response->json();
                  if (!$response->successful() || empty($result['success']) || !$result['success']) {
                      return redirect()->back()
                          ->with('error', 'Le reCAPTCHA n\'a pas été validé.');
                  }
              } catch (\Exception $e) {
                  return redirect()->back()
                      ->with('error', 'يرجى تأكيد أنك لست روبوتًا');
              }
        $request->validate([
            'titre_P' => 'required|string|max:255',
            'ordre_P' => 'required|integer',
            'guide_id' => 'required|integer|exists:guides,id_G',
            'image_titre' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048',
        ]);

        $page = Page::findOrFail($id);
        $page->titre_P = $request->titre_P;
        $page->ordre_P = $request->ordre_P;

        if ($request->hasFile('image_titre')) {

            if ($page->image_titre && file_exists(public_path('idmej/uploads/' . $page->image_titre))) {
                unlink(public_path('idmej/uploads/' . $page->image_titre));
            }

            $image = $request->file('image_titre');
            $imageName = time() . '.' . $image->getClientOriginalExtension();
            $image->move(public_path('uploads'), $imageName);
            $page->image_titre = $imageName;
        }
        $page->save();

        return redirect()->route('guides.listepages', ['id' => $request->guide_id])->with('success', 'Page mis à jour avec succès');
    }

    public function updateSection(Request $request, $id)
    {
$recaptcha = $request->input('g-recaptcha-response');
              if (!$recaptcha) {
                  return redirect()->back()
                      ->with('error', 'يرجى تأكيد أنك لست روبوتًا');
              }
              try {
                  $url = "https://www.google.com/recaptcha/api/siteverify";
                  $response = Http::asForm()->timeout(10)->post($url, [
                      'secret' => config('services.recaptcha.secret_key'),
                      'response' => $recaptcha,
                      'remoteip' => $request->ip(),
                  ]);
          
                  $result = $response->json();
                  if (!$response->successful() || empty($result['success']) || !$result['success']) {
                      return redirect()->back()
                          ->with('error', 'Le reCAPTCHA n\'a pas été validé.');
                  }
              } catch (\Exception $e) {
                  return redirect()->back()
                      ->with('error', 'يرجى تأكيد أنك لست روبوتًا');
              }

        $request->validate([
            'titre_S' => 'required|string|max:255',
            'ordre_S' => 'required|integer',
            'contenue_S' => 'nullable|string',
            'page_id' => 'required|integer|exists:pages,id_P',

        ]);

        $section = Section::findOrFail($id);
        $section->titre_S = $request->titre_S;
        $section->ordre_S = $request->ordre_S;
        $section->contenue_S = $request->contenue_S;
        $section->save();

        return redirect()->route('pages.listesections', ['id' => $request->page_id])->with('success', 'section mis à jour avec succès');
    }

    public function updateInfoSupp(Request $request, $id)
    {
$recaptcha = $request->input('g-recaptcha-response');
              if (!$recaptcha) {
                  return redirect()->back()
                      ->with('error', 'يرجى تأكيد أنك لست روبوتًا');
              }
              try {
                  $url = "https://www.google.com/recaptcha/api/siteverify";
                  $response = Http::asForm()->timeout(10)->post($url, [
                      'secret' => config('services.recaptcha.secret_key'),
                      'response' => $recaptcha,
                      'remoteip' => $request->ip(),
                  ]);
          
                  $result = $response->json();
                  if (!$response->successful() || empty($result['success']) || !$result['success']) {
                      return redirect()->back()
                          ->with('error', 'Le reCAPTCHA n\'a pas été validé.');
                  }
              } catch (\Exception $e) {
                  return redirect()->back()
                      ->with('error', 'يرجى تأكيد أنك لست روبوتًا');
              }
        $request->validate([
            'link' => 'nullable|max:255',
            'ordre_I' => 'required|integer',
            'images.*' => 'nullable|file|mimes:jpeg,png,jpg,gif,svg|max:2048',
            'id_ob' => 'required|integer',
            'nbtype' => 'required|integer',
            'pdf' => 'nullable|file|mimes:jpg,jpeg,png,pdf,doc,docx,zip',
        ]);


        $infosupp = Info_supp::findOrFail($id);
        $infosupp->link = $request->input('link');
        $infosupp->ordre_I = $request->input('ordre_I');


        if ($request->hasFile('images')) {

            $images = $request->file('images');
            $image = $images[0];
            $fileName = time() . '_' . $image->getClientOriginalName();
            $destinationPath = 'uploads';
            $image->move($destinationPath, $fileName);
            $infosupp->image = $fileName;
        }




        if ($request->nbtype == 1) {
            $infosupp->save();
            return redirect()->route('listesinfosuppsP', ['id' => $infosupp->id_P])->with('success', 'Information supplémentaire mise à jour avec succès.');
        } elseif ($request->nbtype == 2) {

            //pdf
            if ($request->hasFile('pdf')) {
                $pdfTitre = $request->file('pdf');
                $pdfName = time() . '_' . $pdfTitre->getClientOriginalName();
                $destinationPath = 'uploads';
                $pdfTitre->move($destinationPath , $pdfName);
                $infosupp->pdf=$pdfName;
            }
            $infosupp->save();
            return redirect()->route('listesinfosuppsS', ['id' => $infosupp->id_S])->with('success', 'Information supplémentaire mise à jour avec succès.');
        }
    }





    //-----------------------------------------------------------------------------------------------------------
    public function destroy($id)
    {

        $guide = Guide::findOrFail($id);

        foreach ($guide->pages as $page) {
            foreach ($page->sections as $section) {
                foreach ($section->info_supps as $info) {
                    $info->delete();
                }
                $section->delete();
            }
            foreach ($page->info_supps as $info) {
                $info->delete();
            }
            $page->delete();
        }
        $tp=$guide->id_type;
        $guide->delete();
        return redirect()->route('guides.index', ['tp' => $tp])->with('success', 'Guide supprimé avec succès.');
    }

    public function destroyPage($id)
    {
        $page = Page::findOrFail($id);
        foreach ($page->sections as $section) {
            foreach ($section->info_supps as $info) {
                $info->delete();
            }
            $section->delete();
        }
        $guideId = $page->guide->id_G;
        foreach ($page->info_supps as $info) {
            $info->delete();
        }
        $page->delete();
        return redirect()->route('guides.listepages', ['id' => $guideId])->with('success', 'Page supprimée avec succès.');
    }

    public function destroySection($id)
    {
        $section = Section::findOrFail($id);
        foreach ($section->info_supps as $info) {
            $info->delete();
        }
        $pageId = $section->page->id_P;
        $section->delete();
        return redirect()->route('pages.listesections', ['id' => $pageId])->with('success', 'Section supprimée avec succès.');
    }

    public function destroyInfosupp($id , $nbtype)
    {
        $infoSupp = Info_supp::findOrFail($id);
        if ($nbtype == 1) {
            $id_ob = $infoSupp->page->id_P;
        } elseif ($nbtype == 2) {
            $id_ob = $infoSupp->section->id_S;
        }
        $infoSupp->delete();
        if ($nbtype == 1) {
            return redirect()->route('listesinfosuppsP', ['id' => $id_ob])->with('success', 'InfoSupp SUPP avec succès');
        } elseif ($nbtype == 2) {
            return redirect()->route('listesinfosuppsS', ['id' => $id_ob])->with('success', 'InfoSuppSUPP avec succès');
        }
    }


    //-----------------------------------------------------------------------------------------------------------

    //filter
    public function index1(Request $request)
    {
        $query = Guide::query();

        if ($request->has('language_id') && !empty($request->language_id)) {
            $query->where('id_L', $request->language_id);
        }

        if ($request->has('title') && !empty($request->title)) {
            $query->where('titre_G', 'like', '%' . $request->title . '%');
        }

        $guides = $query->get();


        return view('BackOfficeAR.gestion_guide.listeguides', compact('guides'));
    }



}




