<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\Association;
use App\Models\TypeFinancement;
use App\Models\TypeFormulaire;
use App\Models\DemandeFinancement;
use App\Models\Projet;
use App\Models\Superviseur;
use App\Models\ActivitePhase;
use App\Models\EstimationBudget;
use App\Models\ContributeurProjet;
use App\Models\PosteDepense;
use App\Models\TypeDocument;
use App\Models\DocumentsFinancementList;
use App\Models\DocumentsFinancement;

class FinancementStepperController extends Controller
{

    public function create()
    {
        $formulaire = TypeFormulaire::find(6);
        $formulaire5 = TypeFormulaire::find(7);
        $formulaire7 = TypeFormulaire::find(8);
        $type_financement = TypeFinancement::all();

         $association = session('association_id')
        ? Association::with('demandes','projets')->find(session('association_id'))
        : null;

    $selectedTypes = $association
        ? $association->demandes->pluck('type_financement_id')->toArray()
        : [];

        return view('financement.last_stepper', compact(
            'formulaire','type_financement','association','selectedTypes','formulaire5','formulaire7'
        ));
    }

    public function editStep1($id)
    {
        $association = Association::findOrFail($id);
        $type_financement = TypeFinancement::all();

        $selectedTypes = DemandeFinancement::where('association_id', $association->id_association)
            ->pluck('type_financement_id')
            ->toArray();

        $formulaire = TypeFormulaire::find($association->id_formulaire);

        return view('financement.last_stepper', compact('association', 'type_financement', 'formulaire', 'selectedTypes'));
    }


    public function storeStep1(Request $request)
    {
        $request->validate([
            'nom_association' => 'required|string|max:255',
            'adresse' => 'required|string|max:255',
            'types_financement' => 'required|array|min:1',
            'id_formulaire' => 'required|integer|exists:tp_type_formulaire,id_type',
        ]);

        // 🔸 Création de l'association
        $association = Association::create($request->only([
            'nom_association',
            'adresse',
            'code_postal',
            'tel',
            'fax',
            'date_creation',
            'num_visa',
            'date_visa',
            'num_identification_fiscale',
            'num_compte_courant',
            'banque',
            'adresse_mail',
            'adresse_site_internet',
            'nom_president_association',
            'tel_personnel',
            'num_membre_bureau_national_a',
            'num_bureaux_regionaux',
            'num_total_membre',
            'id_formulaire',
        ]));

        // 🔸 Création des types de financement choisis
        foreach ($request->types_financement as $typeFinId) {
            DemandeFinancement::create([
                'association_id' => $association->id_association,
                'type_financement_id' => $typeFinId,
                'type_formulaire_id' => $request->id_formulaire,
                'id_user' => auth()->id(),
            ]);
        }

        // 🔸 Sauvegarder l’ID dans la session pour la suite
        session(['association_id' => $association->id_association]);

        return response()->json([
            'success' => true,
            'association_id' => $association->id_association,
            'message' => 'تم حفظ البيانات بنجاح',
        ]);
    }

}
