<?php



namespace App\Http\Controllers\Financement;



use App\Http\Controllers\Controller;

use Illuminate\Support\Facades\Validator;

use Illuminate\Support\Facades\Storage;

use Illuminate\Http\Request;

use App\Models\Projet;

use App\Models\TypeFormulaire;

use App\Models\TpTypeDocument;

use App\Models\DocumentsFinancement;

use App\Models\TpStatut;

use App\Models\DocumentsFinancementList;

use App\Mail\StatutDocumentChanged;

use App\Notifications\StatutDocumentNotification;

use App\Models\Utilisateur;

use Illuminate\Support\Facades\Notification;

use Illuminate\Support\Facades\Mail;

use Illuminate\Support\Facades\DB;

use Illuminate\Support\Facades\Auth;

use App\Models\Association;

use App\Models\TypeFinancement;

use App\Models\DemandeFinancement;

use App\Models\Superviseur;

use App\Models\ActivitePhase;

use App\Models\EstimationBudget;

use App\Models\ContributeurProjet;

use App\Models\PosteDepense;

use App\Models\TypeDocument;

use Illuminate\Support\Collection;



class DocumentFinancementController extends Controller

{

    public function index()

    {

        $documents = DocumentsFinancementList::with('statut1','statut2', 'projet', 'user')

            ->where('id_user', auth()->id())   

            ->orderBy('id_doc_list', 'desc') 

            ->where('brouillon', false) 

            ->paginate(10);                   



        return view('financement.documents_financement.index', compact('documents'));

    }



    public function brouillons()

{

    $documents = DocumentsFinancementList::with('statut1', 'statut2', 'projet', 'user')

        ->where('id_user', auth()->id())

        ->where('brouillon', true) 

        ->orderBy('id_doc_list', 'desc')

        ->paginate(10);



    return view('financement.documents_financement.brouillons', compact('documents'));

}





    public function create(Request $request)

    {

        $formulaire = TypeFormulaire::find(6);

        $type_financement = TypeFinancement::all();



        $association = session('association_id')

            ? Association::with('demandes','projets')->find(session('association_id'))

            : null;



        $selectedTypes = $association

            ? $association->demandes->pluck('type_financement_id')->toArray()

            : [];



        $formulaire2 = TypeFormulaire::find(7);

        $associations = Association::all();



        $demande_id = $request->demande_id;

        $demande = DemandeFinancement::with('association')->find($demande_id);



        $selectedAssociationId = $demande && $demande->association ? $demande->association->id_association : null;

        $selectedAssociationName = $demande && $demande->association ? $demande->association->nom_association : null;



        $formulaire3 = TypeFormulaire::find(8);

        $typedocum = TpTypeDocument::all();

        $id_projet = $request->query('projet_id');

        $documents = DocumentsFinancementList::where('id_projet', $id_projet)->get();



        return view('financement.documents_financement.create', compact(

            'formulaire2','associations','demande_id','demande',

            'formulaire','type_financement','association','selectedTypes','selectedAssociationId','selectedAssociationName',

            'formulaire3','typedocum','id_projet','documents'

        ));

    }



    public function storeAll(Request $request)

    {

            $isBrouillon = $request->brouillon == 1;

            if ($isBrouillon) {

                $rules = [

                    'nom_association' => 'required|string|max:255',
					'types_financement' => 'required|array|min:1',
                ];
				
				$messages = [
        'nom_association.required' => 'الرجاء إدخال اسم الجمعية.',
		 'types_financement.required' => 'الرجاء اختيار نوع التمويل.',
    ];

            } else {

                $rules = [

                    // Association

                    'nom_association' => 'required|string|max:255',

                    'adresse' => 'required|string|max:255',

                    'code_postal' => 'required|string|max:20',

                    'tel' => 'required|string|max:50',

                    'fax' => 'required|string|max:50',

                    'date_creation' => 'required|date',

                    'num_visa' => 'required|string|max:100',

                    'date_visa' => 'required|date',

                    'num_identification_fiscale' => 'required|string|max:100',

                    'num_compte_courant' => 'required|string|max:100',

                    'banque' => 'required|string|max:255',

                    'adresse_mail' => 'required|email|max:255',

                    'adresse_site_internet' => 'required|string|max:255',

                    'nom_president_association' => 'required|string|max:255',

                    'tel_personnel' => 'required|string|max:50',

                    'num_membre_bureau_national_a' => 'required|integer',

                    'num_bureaux_regionaux' => 'required|integer',

                    'num_total_membre' => 'required|integer',

                    'types_financement' => 'required|array|min:1',

                    'id_formulaire' => 'required|integer|exists:tp_type_formulaire,id_type',



                    // Superviseur

                    'nom_prenom_sup' => 'required|string|max:100',

                    'profession_sup' => 'required|string|max:100',

                    'role_sup'       => 'required|string|max:100',

                    'tel_sup'        => 'required|string|max:12',

                    'email_sup'      => 'required|email|max:255',



                    // Projet

                    'nom_projet'               => 'required|string|max:255',

                    'justification_realisation'=> 'required|string|max:255',

                    'objectives'               => 'required|string',

                    'public'                   => 'required|string|max:255',

                    'nombre_spectateur'        => 'required|integer|min:1',

                    'tranch_age_min'           => 'required|integer|min:0',

                    'tranch_age_max'           => 'required|integer|gte:tranch_age_min',

                    'parties_realisation'      => 'required|string',

                    'resultat_quantitatif'     => 'required|string',

                    'resultat_qualitatif'      => 'required|string',

                    'perspectives'             => 'required|string',



                    // Phases

                    'phases.*.description'         => 'required|string|max:200',

                    'phases.*.completion_date'     => 'required|date',

                    'phases.*.completion_location' => 'required|string|max:100',



                    // Budget

                    'budget.*.total_cost'      => 'required|numeric|min:0',

                    'budget.*.self_percent'    => 'required|numeric|min:0|max:100',

                    'budget.*.self_amount'     => 'required|numeric|min:0',

                    'budget.*.ministry_amount' => 'required|numeric|min:0',

                    'budget.*.ministry_percent'=> 'required|numeric|min:0|max:100',

                    'budget.*.supporters.*.name'   => 'required|string|max:255',

                    'budget.*.supporters.*.amount' => 'required|numeric|min:0',

                    'budget.*.supporters.*.percent'=> 'required|numeric|min:0|max:100',



                    // Dépenses

                    'depenses.*.libelle_depense' => 'required|string|max:200',

                    'depenses.*.description'     => 'required|string|max:255',

                    'depenses.*.cout'            => 'required|numeric|min:0',



                    // Documents

                    'doc_fin.*.id_doc' => 'required|integer|exists:tp_type_document,id_type_doc',

                    'doc_fin.*.file' => 'required|file|mimes:pdf,jpg,jpeg,png,doc,docx|max:2048',


                ];
				
				$messages = [
    // Association
    'nom_association.required' => 'الرجاء إدخال اسم الجمعية.',
    'adresse.required' => 'الرجاء إدخال العنوان.',
    'code_postal.required' => 'الرجاء إدخال الرمز البريدي.',
    'tel.required' => 'الرجاء إدخال رقم الهاتف.',
    'fax.required' => 'الرجاء إدخال رقم الفاكس.',
    'date_creation.required' => 'الرجاء إدخال تاريخ التأسيس.',
    'parties_realisation' => 'الرجاء إدخال الأطراف المشاركة في الإنجاز.',
    'resultat_quantitatif' => 'الرجاء إدخال  النتائج الكمية.',
    'resultat_qualitatif' => 'الرجاء إدخال  النتائج النوعية.',
    'perspectives' => 'الرجاء إدخال الآفاق المنتظرة.',
    'num_visa.required' => 'الرجاء إدخال رقم التأشيرة.',
    'date_visa.required' => 'الرجاء إدخال تاريخ التأشيرة.',
    'num_identification_fiscale.required' => 'الرجاء إدخال المعرف الجبائي.',
    'num_compte_courant.required' => 'الرجاء إدخال رقم الحساب الجاري.',
    'banque.required' => 'الرجاء إدخال اسم البنك.',
    'adresse_mail.required' => 'الرجاء إدخال البريد الإلكتروني.',
    'adresse_site_internet.required' => 'الرجاء إدخال الموقع الإلكتروني.',
    'nom_president_association.required' => 'الرجاء إدخال اسم رئيس الجمعية.',
    'tel_personnel.required' => 'الرجاء إدخال الهاتف الشخصي.',
    'num_membre_bureau_national_a.required' => 'الرجاء إدخال عدد أعضاء المكتب الوطني.',
    'num_bureaux_regionaux.required' => 'الرجاء إدخال عدد المكاتب الجهوية.',
    'num_total_membre.required' => 'الرجاء إدخال العدد الجملي للأعضاء.',
    'types_financement.required' => 'الرجاء اختيار نوع التمويل.',
    'id_formulaire.required' => 'الرجاء اختيار نوع الاستمارة.',

    // Superviseur
    'nom_prenom_sup.required' => 'الرجاء إدخال اسم المشرف.',
    'profession_sup.required' => 'الرجاء إدخال مهنة المشرف.',
    'role_sup.required' => 'الرجاء إدخال دور المشرف.',
    'tel_sup.required' => 'الرجاء إدخال رقم هاتف المشرف.',
    'email_sup.required' => 'الرجاء إدخال بريد المشرف.',

    // Projet
    'nom_projet.required' => 'الرجاء إدخال اسم المشروع.',
    'justification_realisation.required' => 'الرجاء إدخال مبررات الإنجاز.',
    'objectives.required' => 'الرجاء إدخال الأهداف.',
    'public.required' => 'الرجاء إدخال الفئة المستهدفة.',
    'nombre_spectateur.required' => 'الرجاء إدخال عدد المتفرجين.',
    'tranch_age_min.required' => 'الرجاء إدخال الحد الأدنى للعمر.',
    'tranch_age_max.required' => 'الرجاء إدخال الحد الأقصى للعمر.',
    'tranch_age_max.gte' => 'يجب أن يكون الحد الأقصى للعمر أكبر من الحد الأدنى.',
    // Phases
    'phases.*.description.required' => 'الرجاء إدخال وصف المرحلة.',
    'phases.*.completion_date.required' => 'الرجاء إدخال تاريخ الإنجاز.',
    'phases.*.completion_location.required' => 'الرجاء إدخال مكان الإنجاز.',

    // Budget
    'budget.*.total_cost.required' => 'الرجاء إدخال التكلفة الجملية.',
    'budget.*.self_percent.required' => 'الرجاء إدخال النسبة المائوية.',
    'budget.*.self_amount.required' => 'الرجاء إدخال المبلغ بالدينار.',
    'budget.*.ministry_amount.required' => 'الرجاء إدخال المبلغ بالدينار.',
    'budget.*.ministry_percent.required' => 'الرجاء إدخال النسبة المائوية.',
    
    'budget.*.supporters.*.name.required' => 'الرجاء إدخال اسم المساند.',
    'budget.*.supporters.*.amount.required' => 'الرجاء إدخال مبلغ المساندة.',
    'budget.*.supporters.*.percent.required' => 'الرجاء إدخال النسبة المائوية.',

    // Dépenses
    'depenses.*.libelle_depense.required' => 'الرجاء إدخال اسم المصروف.',
    'depenses.*.description.required' => 'الرجاء إدخال وصف المصروف.',
    'depenses.*.cout.required' => 'الرجاء إدخال التكلفة.',

    // Documents
    'doc_fin.*.id_doc.required' => 'الرجاء اختيار نوع الوثيقة.',
    'doc_fin.*.file.required' => 'الرجاء تحميل الوثيقة.',
    
];
}



            $docRules = [];

	if ($isBrouillon) {
		foreach($request->doc_fin ?? [] as $i => $doc) {
			$docRules["doc_fin.$i.file"] = 'nullable|file|mimes:pdf,jpg,jpeg,png,doc,docx|max:2048';
		}

	} else {
		foreach($request->doc_fin ?? [] as $i => $doc) {
			$rule = [];

			if(!in_array($doc['id_doc'], [15,17])) {
				$rule[] = 'required';
			}

			$rule[] = 'file';
			$rule[] = 'mimes:pdf,jpg,jpeg,png,doc,docx';
			$rule[] = 'max:2048';

			$docRules["doc_fin.$i.file"] = implode('|', $rule);
		}

	}
    $rules = array_merge($rules, $docRules);

            $request->validate($rules, $messages);

            

 DB::beginTransaction();
try {
            $request->merge([

                'types_financement' => $request->types_financement ?? [],

                'phases' => $request->phases ?? [],

                'budget' => $request->budget ?? [],

                'depenses' => $request->depenses ?? [],

                'doc_fin' => $request->doc_fin ?? [],

            ]);
            $association = Association::create($request->only([

                'nom_association','adresse','code_postal','tel','fax',

                'date_creation','num_visa','date_visa','num_identification_fiscale',

                'num_compte_courant','banque','adresse_mail','adresse_site_internet',

                'nom_president_association','tel_personnel','num_membre_bureau_national_a',

                'num_bureaux_regionaux','num_total_membre','id_formulaire'

            ]));
            $demande = null;

            if (!empty($request->types_financement)) {

                foreach ($request->types_financement as $typeFinId) {

                    $demande = DemandeFinancement::create([

                        'association_id'      => $association->id_association,

                        'type_financement_id' => $typeFinId,

                        'type_formulaire_id'  => $request->id_formulaire,

                        'id_user'             => auth()->id(),

                    ]);

                }

            }



            $superviseur = Superviseur::create($request->only([

                'nom_prenom_sup','profession_sup','role_sup','tel_sup','email_sup'

            ]));



            $projet = Projet::create([

                'id_superviseur'          => $superviseur->id_sup,

                'id_formulaire'           => $request->id_formulaire,

                'id_demande'              => $demande?->id_demande_fin, 

                'id_user'                 => auth()->id(),

                'nom_projet'              => $request->nom_projet,

                'justification_realisation'=> $request->justification_realisation,

                'objectives'              => $request->objectives,

                'public'                  => $request->public,

                'nombre_spectateur'       => $request->nombre_spectateur,

                'tranch_age_min'          => $request->tranch_age_min,

                'tranch_age_max'          => $request->tranch_age_max,

                'parties_realisation'     => $request->parties_realisation,

                'resultat_quantitatif'    => $request->resultat_quantitatif,

                'resultat_qualitatif'     => $request->resultat_qualitatif,

                'perspectives'            => $request->perspectives,

            ]);



            foreach ($request->phases as $phase) {

                if (!empty($phase['description'])) {

                    ActivitePhase::create([

                        'id_projet' => $projet->id_projet,

                        'description' => $phase['description'],

                        'completion_date' => $phase['completion_date'] ?? null,

                        'completion_location' => $phase['completion_location'] ?? null,

                    ]);

                }

            }



            $estimation = null;

            foreach ($request->budget as $budget) {

                $estimation = EstimationBudget::create([

                    'projet_id'                     => $projet->id_projet,

                    'cout_total_estime'             => $budget['total_cost'] ?? 0,

                    'financement_propre_pourcentage'=> $budget['self_percent'] ?? 0,

                    'financement_propre_montant'    => $budget['self_amount'] ?? 0,

                    'aide_ministere_montant'        => $budget['ministry_amount'] ?? 0,

                    'aide_ministere_pourcentage'    => $budget['ministry_percent'] ?? 0,

                ]);



                if (!empty($budget['supporters'])) {

                    foreach ($budget['supporters'] as $supporter) {

                        if (!empty($supporter['name'])) {

                            ContributeurProjet::create([

                                'id_estimation_budget' => $estimation->id_estimation,

                                'nom' => $supporter['name'],

                                'montant' => $supporter['amount'] ?? 0,

                                'pourcentage' => $supporter['percent'] ?? 0,

                            ]);

                        }

                    }

                }

            }



            foreach ($request->depenses as $depense) {

                if (!empty($depense['libelle_depense'])) {

                    PosteDepense::create([

                        'id_estimation_budget' => $estimation?->id_estimation,

                        'libelle_depense' => $depense['libelle_depense'],

                        'description' => $depense['description'] ?? '',

                        'cout' => $depense['cout'] ?? 0,

                    ]);

                }

            }



            $docList = DocumentsFinancementList::create([

                'id_projet'     => $projet->id_projet,

                'id_formulaire' => $request->id_formulaire,

                'id_statut1'    => 2,

                'id_statut2'    => null,

                'id_user'       => auth()->id(),

                'brouillon'     => $request->brouillon ? 1 : 0,

            ]);



            foreach ($request->doc_fin as $doc) {

                if (!empty($doc['id_doc'])) {

                    $filePath = isset($doc['file']) ? $doc['file']->store('documents_financement', 'public') : null;

                    DocumentsFinancement::create([

                        'id_doc'      => $doc['id_doc'],

                        'file'        => $filePath,


                        'id_doc_list' => $docList->id_doc_list,

                    ]);

                }

            }



            DB::commit();

            return redirect()->route('doc_fin.index')

                ->with('success', 'تم إنشاء النموذج بنجاح');

        }



        catch (\Exception $e) {

            DB::rollBack();

            return back()->withErrors(['error' => 'حدث خطأ أثناء الحفظ: ' . $e->getMessage()])

                        ->withInput();

        }

    }



    public function show($id)

    {

        $docList = DocumentsFinancementList::with([

            'projet.superviseur',

            'projet.activites',

            'projet.estimationBudget',

            'projet.estimationBudget.contributeurs',

            'projet.estimationBudget.postesDepense','documents',

            'documents.typeDocument',

            'statut1', 'statut2'

        ])->findOrFail($id);



        $formulaire = TypeFormulaire::find(6);

        $formulaire2 = TypeFormulaire::find(7);

        $formulaire3 = TypeFormulaire::find(8);

        $type_financement = TypeFinancement::all();



        $demande_id = $docList->projet->id_demande;

        $demande = DemandeFinancement::with('association')->find($demande_id);



        $selectedAssociationId = $demande && $demande->association 

            ? $demande->association->id_association 

            : null;



        $selectedAssociationName = $demande && $demande->association 

            ? $demande->association->nom_association 

            : null;



        $id_projet = $docList->projet->id_projet; 

        $documents = DocumentsFinancementList::where('id_projet', $id_projet)->get();

        $typedocum = TpTypeDocument::all();



        $selectedTypes = DemandeFinancement::where('association_id', $demande->association_id)

                                            ->pluck('type_financement_id')

                                            ->toArray();



        $documents = $docList->documents;



        return view('financement.documents_financement.show', compact(

            'docList','formulaire','formulaire2','formulaire3','type_financement',

            'demande_id','demande','selectedAssociationId','selectedAssociationName','documents',

            'id_projet','typedocum','selectedTypes','docList'

        ));

    }



        public function brouillons_show($id)

    {

        $docList = DocumentsFinancementList::with([

            'projet.superviseur',

            'projet.activites',

            'projet.estimationBudget',

            'projet.estimationBudget.contributeurs',

            'projet.estimationBudget.postesDepense','documents',

            'documents.typeDocument',

            'statut1', 'statut2'

        ])->findOrFail($id);



        $formulaire = TypeFormulaire::find(6);

        $formulaire2 = TypeFormulaire::find(7);

        $formulaire3 = TypeFormulaire::find(8);

        $type_financement = TypeFinancement::all();



        $demande_id = $docList->projet->id_demande;

        $demande = DemandeFinancement::with('association')->find($demande_id);



        $selectedAssociationId = $demande && $demande->association 

            ? $demande->association->id_association 

            : null;



        $selectedAssociationName = $demande && $demande->association 

            ? $demande->association->nom_association 

            : null;



        $id_projet = $docList->projet->id_projet; 

        $documents = DocumentsFinancementList::where('id_projet', $id_projet)->get();

        $typedocum = TpTypeDocument::all();



        $selectedTypes = DemandeFinancement::where('association_id', $demande->association_id)

                                            ->pluck('type_financement_id')

                                            ->toArray();



        $documents = $docList->documents;



        return view('financement.documents_financement.brouillons_show', compact(

            'docList','formulaire','formulaire2','formulaire3','type_financement',

            'demande_id','demande','selectedAssociationId','selectedAssociationName','documents',

            'id_projet','typedocum','selectedTypes','docList'

        ));

    }



    

    public function edit($id)

    {

        $docList = DocumentsFinancementList::with([

            'projet.superviseur',

            'projet.activites',

            'projet.estimationBudget',

            'projet.estimationBudget.contributeurs',

            'projet.estimationBudget.postesDepense','documents',

            'documents.typeDocument',

            'statut1', 'statut2'

        ])->findOrFail($id);



        $formulaire = TypeFormulaire::find(6);

        $formulaire2 = TypeFormulaire::find(7);

        $formulaire3 = TypeFormulaire::find(8);

        $type_financement = TypeFinancement::all();



        $demande_id = $docList->projet->id_demande;

        $demande = DemandeFinancement::with('association')->find($demande_id);



        $selectedAssociationId = $demande && $demande->association 

            ? $demande->association->id_association 

            : null;



        $selectedAssociationName = $demande && $demande->association 

            ? $demande->association->nom_association 

            : null;



        $id_projet = $docList->projet->id_projet; 

        $documents = DocumentsFinancementList::where('id_projet', $id_projet)->get();

        $typedocum = TpTypeDocument::all();



        $selectedTypes = DemandeFinancement::where('association_id', $demande->association_id)

                                            ->pluck('type_financement_id')

                                            ->toArray();



        $documents = $docList->documents;



        return view('financement.documents_financement.edit', compact(

            'docList','formulaire','formulaire2','formulaire3','type_financement',

            'demande_id','demande','selectedAssociationId','selectedAssociationName','documents',

            'id_projet','typedocum','selectedTypes','docList'

        ));

    }





    public function brouillons_edit($id)

    {

        $docList = DocumentsFinancementList::with([

            'projet.superviseur',

            'projet.activites',

            'projet.estimationBudget',

            'projet.estimationBudget.contributeurs',

            'projet.estimationBudget.postesDepense','documents',

            'documents.typeDocument',

            'statut1', 'statut2'

        ])->findOrFail($id);



        $formulaire = TypeFormulaire::find(6);

        $formulaire2 = TypeFormulaire::find(7);

        $formulaire3 = TypeFormulaire::find(8);

        $type_financement = TypeFinancement::all();



        $demande_id = $docList->projet->id_demande;

        $demande = DemandeFinancement::with('association')->find($demande_id);



        $selectedAssociationId = $demande && $demande->association 

            ? $demande->association->id_association 

            : null;



        $selectedAssociationName = $demande && $demande->association 

            ? $demande->association->nom_association 

            : null;



        $id_projet = $docList->projet->id_projet; 

        $documents = DocumentsFinancementList::where('id_projet', $id_projet)->get();

        $typedocum = TpTypeDocument::all();



        $selectedTypes = DemandeFinancement::where('association_id', $demande->association_id)

                                            ->pluck('type_financement_id')

                                            ->toArray();



        $documents = $docList->documents;



        return view('financement.documents_financement.brouillons_edit', compact(

            'docList','formulaire','formulaire2','formulaire3','type_financement',

            'demande_id','demande','selectedAssociationId','selectedAssociationName','documents',

            'id_projet','typedocum','selectedTypes','docList'

        ));

    }





    public function update(Request $request, $id)

    {

        DB::beginTransaction();



        try {

            $rules = [

                

                    // Association

                    'nom_association' => 'required|string|max:255',

                    'adresse' => 'required|string|max:255',

                    'code_postal' => 'required|string|max:20',

                    'tel' => 'required|string|max:50',

                    'fax' => 'required|string|max:50',

                    'date_creation' => 'required|date',

                    'num_visa' => 'required|string|max:100',

                    'date_visa' => 'required|date',

                    'num_identification_fiscale' => 'required|string|max:100',

                    'num_compte_courant' => 'required|string|max:100',

                    'banque' => 'required|string|max:255',

                    'adresse_mail' => 'required|email|max:255',

                    'adresse_site_internet' => 'required|string|max:255',

                    'nom_president_association' => 'required|string|max:255',

                    'tel_personnel' => 'required|string|max:50',

                    'num_membre_bureau_national_a' => 'required|integer',

                    'num_bureaux_regionaux' => 'required|integer',

                    'num_total_membre' => 'required|integer',

                    'types_financement' => 'required|array|min:1',

                    'id_formulaire' => 'required|integer|exists:tp_type_formulaire,id_type',



                    // Superviseur

                    'nom_prenom_sup' => 'required|string|max:100',

                    'profession_sup' => 'required|string|max:100',

                    'role_sup'       => 'required|string|max:100',

                    'tel_sup'        => 'required|string|max:12',

                    'email_sup'      => 'required|email|max:255',



                    // Projet

                    'nom_projet'               => 'required|string|max:255',

                    'justification_realisation'=> 'required|string|max:255',

                    'objectives'               => 'required|string',

                    'public'                   => 'required|string|max:255',

                    'nombre_spectateur'        => 'required|integer|min:1',

                    'tranch_age_min'           => 'required|integer|min:0',

                    'tranch_age_max'           => 'required|integer|gte:tranch_age_min',

                    'parties_realisation'      => 'required|string',

                    'resultat_quantitatif'     => 'required|string',

                    'resultat_qualitatif'      => 'required|string',

                    'perspectives'             => 'required|string',



                    // Phases

                    'phases.*.description'         => 'required|string|max:200',

                    'phases.*.completion_date'     => 'required|date',

                    'phases.*.completion_location' => 'required|string|max:100',



                    // Budget

                    'budget.*.total_cost'      => 'required|numeric|min:0',

                    'budget.*.self_percent'    => 'required|numeric|min:0|max:100',

                    'budget.*.self_amount'     => 'required|numeric|min:0',

                    'budget.*.ministry_amount' => 'required|numeric|min:0',

                    'budget.*.ministry_percent'=> 'required|numeric|min:0|max:100',

                    'budget.*.supporters.*.name'   => 'required|string|max:255',

                    'budget.*.supporters.*.amount' => 'required|numeric|min:0',

                    'budget.*.supporters.*.percent'=> 'required|numeric|min:0|max:100',



                    // Dépenses

                    



                    'depenses.*.*.libelle_depense' => 'required|string|max:200',

                    'depenses.*.*.description'     => 'required|string|max:255',

                    'depenses.*.*.cout'            => 'required|numeric|min:0',

                    // Documents

                    'doc_fin.*.id_doc' => 'required|integer|exists:tp_type_document,id_type_doc',

                    'doc_fin.*.file' => 'nullable|file|mimes:pdf,jpg,jpeg,png,doc,docx|max:2048',


            ];
				$messages = [
    // Association
    'nom_association.required' => 'الرجاء إدخال اسم الجمعية.',
    'adresse.required' => 'الرجاء إدخال العنوان.',
    'code_postal.required' => 'الرجاء إدخال الرمز البريدي.',
    'tel.required' => 'الرجاء إدخال رقم الهاتف.',
    'fax.required' => 'الرجاء إدخال رقم الفاكس.',
    'date_creation.required' => 'الرجاء إدخال تاريخ التأسيس.',
    'parties_realisation' => 'الرجاء إدخال الأطراف المشاركة في الإنجاز.',
    'resultat_quantitatif' => 'الرجاء إدخال  النتائج الكمية.',
    'resultat_qualitatif' => 'الرجاء إدخال  النتائج النوعية.',
    'perspectives' => 'الرجاء إدخال الآفاق المنتظرة.',
    'num_visa.required' => 'الرجاء إدخال رقم التأشيرة.',
    'date_visa.required' => 'الرجاء إدخال تاريخ التأشيرة.',
    'num_identification_fiscale.required' => 'الرجاء إدخال المعرف الجبائي.',
    'num_compte_courant.required' => 'الرجاء إدخال رقم الحساب الجاري.',
    'banque.required' => 'الرجاء إدخال اسم البنك.',
    'adresse_mail.required' => 'الرجاء إدخال البريد الإلكتروني.',
    'adresse_site_internet.required' => 'الرجاء إدخال الموقع الإلكتروني.',
    'nom_president_association.required' => 'الرجاء إدخال اسم رئيس الجمعية.',
    'tel_personnel.required' => 'الرجاء إدخال الهاتف الشخصي.',
    'num_membre_bureau_national_a.required' => 'الرجاء إدخال عدد أعضاء المكتب الوطني.',
    'num_bureaux_regionaux.required' => 'الرجاء إدخال عدد المكاتب الجهوية.',
    'num_total_membre.required' => 'الرجاء إدخال العدد الجملي للأعضاء.',
    'types_financement.required' => 'الرجاء اختيار نوع التمويل.',
    'id_formulaire.required' => 'الرجاء اختيار نوع الاستمارة.',

    // Superviseur
    'nom_prenom_sup.required' => 'الرجاء إدخال اسم المشرف.',
    'profession_sup.required' => 'الرجاء إدخال مهنة المشرف.',
    'role_sup.required' => 'الرجاء إدخال دور المشرف.',
    'tel_sup.required' => 'الرجاء إدخال رقم هاتف المشرف.',
    'email_sup.required' => 'الرجاء إدخال بريد المشرف.',

    // Projet
    'nom_projet.required' => 'الرجاء إدخال اسم المشروع.',
    'justification_realisation.required' => 'الرجاء إدخال مبررات الإنجاز.',
    'objectives.required' => 'الرجاء إدخال الأهداف.',
    'public.required' => 'الرجاء إدخال الفئة المستهدفة.',
    'nombre_spectateur.required' => 'الرجاء إدخال عدد المتفرجين.',
    'tranch_age_min.required' => 'الرجاء إدخال الحد الأدنى للعمر.',
    'tranch_age_max.required' => 'الرجاء إدخال الحد الأقصى للعمر.',
    'tranch_age_max.gte' => 'يجب أن يكون الحد الأقصى للعمر أكبر من الحد الأدنى.',

    // Phases
    'phases.*.description.required' => 'الرجاء إدخال وصف المرحلة.',
    'phases.*.completion_date.required' => 'الرجاء إدخال تاريخ الإنجاز.',
    'phases.*.completion_location.required' => 'الرجاء إدخال مكان الإنجاز.',

    // Budget
    'budget.*.total_cost.required' => 'الرجاء إدخال التكلفة الجملية.',
    'budget.*.self_percent.required' => 'الرجاء إدخال النسبة المائوية.',
    'budget.*.self_amount.required' => 'الرجاء إدخال المبلغ بالدينار.',
    'budget.*.ministry_amount.required' => 'الرجاء إدخال المبلغ بالدينار.',
    'budget.*.ministry_percent.required' => 'الرجاء إدخال النسبة المائوية.',
    
    'budget.*.supporters.*.name.required' => 'الرجاء إدخال اسم المساند.',
    'budget.*.supporters.*.amount.required' => 'الرجاء إدخال مبلغ المساندة.',
    'budget.*.supporters.*.percent.required' => 'الرجاء إدخال النسبة المائوية.',

    // Dépenses
    'depenses.*.libelle_depense.required' => 'الرجاء إدخال اسم المصروف.',
    'depenses.*.description.required' => 'الرجاء إدخال وصف المصروف.',
    'depenses.*.cout.required' => 'الرجاء إدخال التكلفة.',

    // Documents
    'doc_fin.*.id_doc.required' => 'الرجاء اختيار نوع الوثيقة.',
    'doc_fin.*.file.required' => 'الرجاء تحميل الوثيقة.',
    
];
           
            $request->validate($rules, $messages);
    
            $docList = DocumentsFinancementList::findOrFail($id);

            $projet = $docList->projet;

            $association = $projet->association;

            $superviseur = $projet->superviseur;



            $association->update($request->only([

                'nom_association','adresse','code_postal','tel','fax',

                'date_creation','num_visa','date_visa','num_identification_fiscale',

                'num_compte_courant','banque','adresse_mail','adresse_site_internet',

                'nom_president_association','tel_personnel','num_membre_bureau_national_a',

                'num_bureaux_regionaux','num_total_membre','id_formulaire'

            ]));



            $superviseur->update($request->only([

                'nom_prenom_sup','profession_sup','role_sup','tel_sup','email_sup'

            ]));



            $projet->update([

                'id_formulaire'           => $request->id_formulaire,

                'nom_projet'              => $request->nom_projet,

                'justification_realisation'=> $request->justification_realisation,

                'objectives'              => $request->objectives,

                'public'                  => $request->public,

                'id_user' => auth()->id(),

                'nombre_spectateur'       => $request->nombre_spectateur,

                'tranch_age_min'          => $request->tranch_age_min,

                'tranch_age_max'          => $request->tranch_age_max,

                'parties_realisation'     => $request->parties_realisation,

                'resultat_quantitatif'    => $request->resultat_quantitatif,

                'resultat_qualitatif'     => $request->resultat_qualitatif,

                'perspectives'            => $request->perspectives,

            ]);



            $projet->activites()->delete();

            if ($request->has('phases')) {

                foreach ($request->phases as $phase) {

                    if (!empty($phase['description'])) {

                        ActivitePhase::create([

                            'id_projet'           => $projet->id_projet,

                            'description'         => $phase['description'],

                            'completion_date'     => $phase['completion_date'] ?? null,

                            'completion_location' => $phase['completion_location'] ?? null,

                        ]);

                    }

                }

            }



            if ($projet->estimationBudget && $projet->estimationBudget->count() > 0) {

                foreach ($projet->estimationBudget as $estimation) {

                    $estimation->contributeurs()->delete();

                    $estimation->postesDepense()->delete();

                    $estimation->delete();

                }

            }



            if ($request->has('budget')) {

                foreach ($request->budget as $budget) {

                    $estimation = EstimationBudget::create([

                        'projet_id'                      => $projet->id_projet,

                        'cout_total_estime'              => $budget['total_cost'] ?? 0,

                        'financement_propre_pourcentage' => $budget['self_percent'] ?? 0,

                        'financement_propre_montant'     => $budget['self_amount'] ?? 0,

                        'aide_ministere_montant'         => $budget['ministry_amount'] ?? 0,

                        'aide_ministere_pourcentage'     => $budget['ministry_percent'] ?? 0,

                    ]);



                    if (isset($budget['supporters'])) {

                        foreach ($budget['supporters'] as $supporter) {

                            if (!empty($supporter['name'])) {

                                $contributeurs = ContributeurProjet::create([

                                    'id_estimation_budget' => $estimation->id_estimation,

                                    'nom'        => $supporter['name'],

                                    'montant'    => $supporter['amount'] ?? 0,

                                    'pourcentage'=> $supporter['percent'] ?? 0,

                                ]);

                            }

                        }

                    }



                    if ($request->has('depenses')) {

                        foreach ($request->depenses as $depense) {

                            if (!empty($depense['libelle_depense'])) {

                                PosteDepense::create([

                                    'id_estimation_budget' => $estimation->id_estimation,

                                    'libelle_depense'      => $depense['libelle_depense'],

                                    'description'          => $depense['description'] ?? '',

                                    'cout'                 => $depense['cout'] ?? 0,

                                ]);

                            }

                        }

                    }

                }

            }



            if ($request->has('doc_fin')) {

                foreach ($request->doc_fin as $docData) {

                    $doc = isset($docData['id_doc']) 

                        ? DocumentsFinancement::where('id_doc_list', $docList->id_doc_list)

                                            ->where('id_doc', $docData['id_doc'])

                                            ->first() 

                        : new DocumentsFinancement();



                    if (isset($docData['file'])) {

                        $filePath = $docData['file']->store('documents_financement', 'public');

                        $doc->file = $filePath;

                    }



                    $doc->id_doc = $docData['id_doc'];


                    $doc->id_doc_list = $docList->id_doc_list;

                    $doc->save();

                }

            }



            DB::commit();



            return redirect()->route('doc_fin.index', $docList->id_doc_list)

                ->with('success', 'تم تحديث الوثيقة بنجاح');

        } catch (\Exception $e) {

            DB::rollBack();

            return back()->withErrors(['error' => 'خطأ أثناء التحديث: ' . $e->getMessage()]);

        }

    }





    public function brouillons_update(Request $request, $id)

{

    DB::beginTransaction();



    try {

        $isBrouillon = $request->brouillon == 1; // Détermine si on sauvegarde comme brouillon



        // Validation conditionnelle

        if ($isBrouillon) {

            // Seulement le nom de l'association est obligatoire pour le brouillon

            $rules = [

                'nom_association' => 'required|string|max:255',

            ];

        } else {

            // Validation complète pour le bouton "Envoyer"

            $rules = [

                // Association

                'nom_association' => 'required|string|max:255',

                'adresse' => 'required|string|max:255',

                'code_postal' => 'required|string|max:20',

                'tel' => 'required|string|max:50',

                'fax' => 'required|string|max:50',

                'date_creation' => 'required|date',

                'num_visa' => 'required|string|max:100',

                'date_visa' => 'required|date',

                'num_identification_fiscale' => 'required|string|max:100',

                'num_compte_courant' => 'required|string|max:100',

                'banque' => 'required|string|max:255',

                'adresse_mail' => 'required|email|max:255',

                'adresse_site_internet' => 'required|string|max:255',

                'nom_president_association' => 'required|string|max:255',

                'tel_personnel' => 'required|string|max:50',

                'num_membre_bureau_national_a' => 'required|integer',

                'num_bureaux_regionaux' => 'required|integer',

                'num_total_membre' => 'required|integer',

                'types_financement' => 'required|array|min:1',

                'id_formulaire' => 'required|integer|exists:tp_type_formulaire,id_type',



                // Superviseur

                'nom_prenom_sup' => 'required|string|max:100',

                'profession_sup' => 'required|string|max:100',

                'role_sup'       => 'required|string|max:100',

                'tel_sup'        => 'required|string|max:12',

                'email_sup'      => 'required|email|max:255',



                // Projet

                'nom_projet'               => 'required|string|max:255',

                'justification_realisation'=> 'required|string|max:255',

                'objectives'               => 'required|string',

                'public'                   => 'required|string|max:255',

                'nombre_spectateur'        => 'required|integer|min:1',

                'tranch_age_min'           => 'required|integer|min:0',

                'tranch_age_max'           => 'required|integer|gte:tranch_age_min',

                'parties_realisation'      => 'required|string',

                'resultat_quantitatif'     => 'required|string',

                'resultat_qualitatif'      => 'required|string',

                'perspectives'             => 'required|string',



                // Phases

                'phases.*.description'         => 'required|string|max:200',

                'phases.*.completion_date'     => 'required|date',

                'phases.*.completion_location' => 'required|string|max:100',



                // Budget

                'budget.*.total_cost'      => 'required|numeric|min:0',

                'budget.*.self_percent'    => 'required|numeric|min:0|max:100',

                'budget.*.self_amount'     => 'required|numeric|min:0',

                'budget.*.ministry_amount' => 'required|numeric|min:0',

                'budget.*.ministry_percent'=> 'required|numeric|min:0|max:100',

                'budget.*.supporters.*.name'   => 'required|string|max:255',

                'budget.*.supporters.*.amount' => 'required|numeric|min:0',

                'budget.*.supporters.*.percent'=> 'required|numeric|min:0|max:100',



                // Dépenses

                'depenses.*.*.libelle_depense' => 'required|string|max:200',

                'depenses.*.*.description'     => 'required|string|max:255',

                'depenses.*.*.cout'            => 'required|numeric|min:0',



                // Documents

                'doc_fin.*.id_doc' => 'required|integer|exists:tp_type_document,id_type_doc',

                'doc_fin.*.file' => 'nullable|file|mimes:pdf,jpg,jpeg,png,doc,docx|max:2048',


            ];

        }



        $request->validate($rules);



        // Récupération du document et relations

        $docList = DocumentsFinancementList::findOrFail($id);

        $docList->brouillon = $isBrouillon ? 1 : 0;

        $docList->save();



        $projet = $docList->projet;

        $association = $projet->association;

        $superviseur = $projet->superviseur;



        // Mise à jour Association

        $association->update($request->only([

            'nom_association','adresse','code_postal','tel','fax',

            'date_creation','num_visa','date_visa','num_identification_fiscale',

            'num_compte_courant','banque','adresse_mail','adresse_site_internet',

            'nom_president_association','tel_personnel','num_membre_bureau_national_a',

            'num_bureaux_regionaux','num_total_membre','id_formulaire'

        ]));



        // Mise à jour Superviseur

        $superviseur->update($request->only([

            'nom_prenom_sup','profession_sup','role_sup','tel_sup','email_sup'

        ]));



        // Mise à jour Projet

        $projet->update([

            'id_formulaire'            => $request->id_formulaire,

            'nom_projet'               => $request->nom_projet,

            'justification_realisation'=> $request->justification_realisation,

            'objectives'               => $request->objectives,

            'public'                   => $request->public,

            'id_user'                  => auth()->id(),

            'nombre_spectateur'        => $request->nombre_spectateur,

            'tranch_age_min'           => $request->tranch_age_min,

            'tranch_age_max'           => $request->tranch_age_max,

            'parties_realisation'      => $request->parties_realisation,

            'resultat_quantitatif'     => $request->resultat_quantitatif,

            'resultat_qualitatif'      => $request->resultat_qualitatif,

            'perspectives'             => $request->perspectives,

        ]);



        // Supprimer et recréer les phases

        $projet->activites()->delete();

        if ($request->has('phases')) {

            foreach ($request->phases as $phase) {

                if (!empty($phase['description'])) {

                    ActivitePhase::create([

                        'id_projet'           => $projet->id_projet,

                        'description'         => $phase['description'],

                        'completion_date'     => $phase['completion_date'] ?? null,

                        'completion_location' => $phase['completion_location'] ?? null,

                    ]);

                }

            }

        }



        // Supprimer et recréer le budget

        if ($projet->estimationBudget && $projet->estimationBudget->count() > 0) {

            foreach ($projet->estimationBudget as $estimation) {

                $estimation->contributeurs()->delete();

                $estimation->postesDepense()->delete();

                $estimation->delete();

            }

        }



        if ($request->has('budget')) {

            foreach ($request->budget as $budget) {

                $estimation = EstimationBudget::create([

                    'projet_id'                      => $projet->id_projet,

                    'cout_total_estime'              => $budget['total_cost'] ?? 0,

                    'financement_propre_pourcentage' => $budget['self_percent'] ?? 0,

                    'financement_propre_montant'     => $budget['self_amount'] ?? 0,

                    'aide_ministere_montant'         => $budget['ministry_amount'] ?? 0,

                    'aide_ministere_pourcentage'     => $budget['ministry_percent'] ?? 0,

                ]);



                if (isset($budget['supporters'])) {

                    foreach ($budget['supporters'] as $supporter) {

                        if (!empty($supporter['name'])) {

                            ContributeurProjet::create([

                                'id_estimation_budget' => $estimation->id_estimation,

                                'nom'        => $supporter['name'],

                                'montant'    => $supporter['amount'] ?? 0,

                                'pourcentage'=> $supporter['percent'] ?? 0,

                            ]);

                        }

                    }

                }



                if ($request->has('depenses')) {

                    foreach ($request->depenses as $depense) {

                        if (!empty($depense['libelle_depense'])) {

                            PosteDepense::create([

                                'id_estimation_budget' => $estimation->id_estimation,

                                'libelle_depense'      => $depense['libelle_depense'],

                                'description'          => $depense['description'] ?? '',

                                'cout'                 => $depense['cout'] ?? 0,

                            ]);

                        }

                    }

                }

            }

        }



        // Documents

        if ($request->has('doc_fin')) {

            foreach ($request->doc_fin as $docData) {

                $doc = isset($docData['id_doc'])

                    ? DocumentsFinancement::where('id_doc_list', $docList->id_doc_list)

                                            ->where('id_doc', $docData['id_doc'])

                                            ->first()

                    : new DocumentsFinancement();



                if (isset($docData['file'])) {

                    $filePath = $docData['file']->store('documents_financement', 'public');

                    $doc->file = $filePath;

                }



                $doc->id_doc = $docData['id_doc'];


                $doc->id_doc_list = $docList->id_doc_list;

                $doc->save();

            }

        }



        DB::commit();



        return redirect()->route('doc_fin.brouillons', $docList->id_doc_list)

            ->with('success', 'تم تحديث الوثيقة بنجاح');



    } catch (\Exception $e) {

        DB::rollBack();

        return back()->withErrors(['error' => 'خطأ أثناء التحديث: ' . $e->getMessage()]);

    }

}



    public function destroy($id)

    {

        DB::beginTransaction();



        try {

            $docList = DocumentsFinancementList::with([

                'documents',

                'projet.superviseur',

                'projet.activites',

                'projet.estimationBudget.contributeurs',

                'projet.estimationBudget.postesDepense',

                'projet.demande',

                'projet.demande.association'

            ])->findOrFail($id);



            foreach ($docList->documents as $doc) {

                if ($doc->file && Storage::disk('public')->exists($doc->file)) {

                    Storage::disk('public')->delete($doc->file);

                }

                $doc->delete();

            }



            if ($docList->projet && $docList->projet->activites) {

                $docList->projet->activites()->delete();

            }



            if ($docList->projet && $docList->projet->estimationBudget) {

                foreach ($docList->projet->estimationBudget as $estimation) {

                    $estimation->contributeurs()->delete();

                    $estimation->postesDepense()->delete();

                    $estimation->delete();

                }

            }



            if ($docList->projet && $docList->projet->superviseur) {

                $docList->projet->superviseur->delete();

            }



            $projet = $docList->projet;

            if ($projet) {

                $projet->delete();

            }



            if ($projet && $projet->demande) {

                $association = $projet->demande->association;

                $projet->demande->delete();



                if ($association && $association->demandes()->count() == 0) {

                    $association->delete();

                }

            }



            $docList->delete();



            DB::commit();



            return redirect()->route('doc_fin.index')->with('success', 'تم حذف الوثيقة بنجاح');

        } catch (\Exception $e) {

            DB::rollBack();

            return back()->withErrors(['error' => 'حدث خطأ أثناء الحذف: ' . $e->getMessage()]);

        }

    }









}

