<?php
namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\FieldDefinition;
use Illuminate\Validation\Rule;

class FieldDefinitionController extends Controller
{
    public function index()
    {
        $definitions = FieldDefinition::orderBy('sort_order')->get();
        return view('concours_ext.fields', compact('definitions'));
    }

    // show the create form
public function create()
{
    // load ALL definitions (or only visible ones if you prefer)
    // keyBy('key') makes $definitions->get('diplome') available in the view
    $definitions = FieldDefinition::orderBy('sort_order')->get()->keyBy('key');

    // pass the collection to the view
    return view('concours_ext.create_ar', compact('definitions'));
}
    public function store(Request $request)
    {
        $data = $request->validate([
            'key' => ['required', 'alpha_dash', 'max:100', Rule::unique('field_definitions','key')],
            'label' => ['required', 'string', 'max:255'],
            'input_type' => ['required', 'string', 'max:30'],
            'value_type' => ['nullable', 'string', 'max:30'],
            'options_json' => ['nullable', 'string'],
            'is_visible' => ['nullable', 'boolean'],
            'is_required' => ['nullable', 'boolean'],
            'sort_order' => ['nullable', 'integer'],
        ]);

        $data['is_visible'] = $request->has('is_visible') ? 1 : 0;
        $data['is_required'] = $request->has('is_required') ? 1 : 0;

        // normalize options_json if user pasted CSV/lines
        if (!empty($data['options_json'])) {
            json_decode($data['options_json']);
            if (json_last_error() !== JSON_ERROR_NONE) {
                $opts = array_values(array_filter(array_map('trim', preg_split("/[\r\n,]+/", $data['options_json']))));
                $data['options_json'] = json_encode($opts, JSON_UNESCAPED_UNICODE);
            }
        }

        FieldDefinition::create($data);

        return redirect()->route('field_definitions.index')->with('success', 'تم إضافة الحقل بنجاح.');
    }

    // ... keep your update(), toggleVisibility(), destroy() methods as before ...
}
