<?php

namespace App\Http\Controllers;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Mail;
use App\Mail\AccountConfirmationMail;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use App\Models\Utilisateur;
use App\Models\Identite_personnel;
use App\Models\Role;
use App\Mail\ResetPasswordMail;

class AuthController extends Controller
{
   /*public function registerForm() {
        $roles = Role::whereIn('id_roles', [2, 3])->get();
        $typesIdentite = Identite_personnel::all();
        return view('auth.signup', compact('roles','typesIdentite'));
    }

    public function register(Request $request) {
        $request->validate([
        'nom_prenom' => 'required|string|max:100',
        'id_type_identite' => 'required|exists:tp_type_identite_pers,id_type',
        'passport' => 'nullable|digits:12|unique:utilisateur,passport',
        'num_fiscal' => 'nullable|digits:12|unique:utilisateur,num_fiscal',
        'cin' => 'nullable|string|size:8|unique:utilisateur,cin',
        'date_delivrance_cin' => 'nullable|date',
        'lieu_delivrance_cin' => 'nullable|string|max:100',
        'email' => 'required|email|unique:utilisateur,email',
        'mdp' => 'required|string|min:6|confirmed',
        'role_id' => 'required|exists:roles,id_roles',
 
        ], [
            'nom_prenom.required' => ' الرجاء إدخال الاسم واللقب',
            'cin.required' => ' الرجاء إدخال رقم بطاقة التعريف الوطنية',
            'cin.size' => ' رقم بطاقة التعريف يجب أن يحتوي على 8 أرقام',
            'cin.unique' => ' رقم بطاقة التعريف مستعمل من قبل',
            'date_delivrance_cin.required' => 'الرجاء إدخال تاريخ الإصدار',
            'lieu_delivrance_cin.required' => ' الرجاء إدخال مكان الإصدار',
            'email.required' => ' الرجاء إدخال البريد الإلكتروني',
            'email.email' => ' الرجاء إدخال بريد إلكتروني صحيح',
            'email.unique' => ' هذا البريد الإلكتروني مستخدم بالفعل',
            'mdp.required' => ' الرجاء إدخال كلمة المرور',
            'mdp.min' => 'كلمة المرور يجب أن تحتوي على الأقل 6 حروف',
            'mdp.confirmed' => ' تأكيد كلمة المرور غير متطابق',
            'role_id.required' => 'الرجاء اختيار نوع المستخدم',
            'role_id.exists' => 'نوع المستخدم المختار غير صالح',
        ]);

        $user = Utilisateur::create([
            'nom_prenom' => $request->nom_prenom,
            'cin' => $request->cin,
            'date_delivrance_cin' => $request->date_delivrance_cin,
            'lieu_delivrance_cin' => $request->lieu_delivrance_cin,
            'email' => $request->email,
            'mdp' => Hash::make($request->mdp),
            'est_active' => false,
        ]);
        $user->roles()->attach($request->role_id);

        $rolesNeedingEmail = [2, 3]; 
        if (in_array((int)$request->role_id, $rolesNeedingEmail)) {
            $code = $this->generateConfirmationCode(8);
            $user->confirmation_code = $code;
            $user->confirmation_expires_at = now()->addHours(1);
            $user->save();
          
            Mail::to($user->email)->send(new AccountConfirmationMail($user));
    
            return redirect()->route('register.confirm.form', $user->id)
                ->with('info', 'تم إرسال رمز التأكيد إلى بريدك الإلكتروني. الرجاء إدخاله لإكمال التسجيل.');
        }

        return redirect()->route('login')->with('success', 'تم إنشاء الحساب بنجاح. سيتم تفعيله من طرف الإدارة.');
    }*/


public function registerForm()
{
    $typesIdentite = Identite_personnel::all();
    return view('auth.signup', compact('typesIdentite'));
}

public function register(Request $request)
{
    $request->validate([
        'nom_prenom'          => 'required|string|max:100',
        'id_type_identite'    => 'required|exists:tp_type_identite_pers,id_type',
        'passport'            => 'nullable|digits_between:8,12|unique:utilisateur,passport',
        'num_fiscal'          => 'nullable|digits:12|unique:utilisateur,num_fiscal',
        'cin'                 => 'nullable|string|size:8|unique:utilisateur,cin',
        'date_delivrance_cin' => 'nullable|date',
        'lieu_delivrance_cin' => 'nullable|string|max:100',
        'email'               => 'required|email|unique:utilisateur,email',
        'mdp'                 => 'required|string|min:6|confirmed',
    ], [
        'nom_prenom.required' => 'الرجاء إدخال الاسم واللقب',
        'email.required'      => ' الرجاء إدخال البريد الإلكتروني',
        'email.unique'        => ' هذا البريد الإلكتروني مستخدم بالفعل',
        'mdp.required'        => ' الرجاء إدخال كلمة المرور',
        'mdp.confirmed'       => ' تأكيد كلمة المرور غير متطابق',
    ]);

    // Attribution automatique du rôle selon l'identité
    $roleId = null;
    if ((int)$request->id_type_identite === 1 || (int)$request->id_type_identite === 2) {
        $roleId = 3; // citoyen
    } elseif ((int)$request->id_type_identite === 3) {
        $roleId = 2; // association
    }

    $user = Utilisateur::create([
        'nom_prenom'          => $request->nom_prenom,
        'id_type_identite'          => $request->id_type_identite,
        'cin'                 => $request->cin,
        'date_delivrance_cin' => $request->date_delivrance_cin,
        'lieu_delivrance_cin' => $request->lieu_delivrance_cin,
        'passport'            => $request->passport,
        'num_fiscal'          => $request->num_fiscal,
        'email'               => $request->email,
        'mdp'                 => Hash::make($request->mdp),
        'est_active'          => false,
    ]);
    $user->roles()->attach($roleId);

    // Confirmation email pour certains rôles
    if (in_array($roleId, [2, 3])) {
        $code = $this->generateConfirmationCode(8);
        $user->confirmation_code = $code;
        $user->confirmation_expires_at = now()->addHours(1);
        $user->save();

        Mail::to($user->email)->send(new AccountConfirmationMail($user));

        return redirect()->route('register.confirm.form', $user->id)
            ->with('info', 'تم إرسال رمز التأكيد إلى بريدك الإلكتروني. الرجاء إدخاله لإكمال التسجيل.');
    }

    return redirect()->route('login')->with('success', 'تم إنشاء الحساب بنجاح. سيتم تفعيله من طرف الإدارة.');
}


    private function generateConfirmationCode($length = 8)
    {
        $chars = 'ABCDEFGHJKLMNPQRSTUVWXYZabcdefghjkmnpqrstuvwxyz23456789!@#$%&*';
        $max = strlen($chars) - 1;
        $code = '';
        for ($i = 0; $i < $length; $i++) {
            $code .= $chars[random_int(0, $max)];
        }
        return $code;
    }

    public function confirmForm(Utilisateur $utilisateur)
    {
        return view('auth.register-confirm', compact('utilisateur'));
    }

    public function confirm(Request $request, Utilisateur $utilisateur)
    {
        $request->validate([
            'confirmation_code' => 'required|string',
        ]);

        if (!$utilisateur->confirmation_code || $utilisateur->confirmation_code !== $request->confirmation_code) {
            return back()->withErrors(['confirmation_code' => 'رمز التأكيد غير صحيح.'])->withInput();
        }

        if ($utilisateur->confirmation_expires_at && now()->greaterThan($utilisateur->confirmation_expires_at)) {
            return back()->withErrors(['confirmation_code' => 'رمز التأكيد منتهي الصلاحية. اطلب رمزًا جديدًا.']);
        }

        $utilisateur->est_active = true;
        $utilisateur->confirmation_code = null;
        $utilisateur->confirmation_expires_at = null;
        $utilisateur->save();

        return redirect()->route('login')->with('success', 'تم تفعيل حسابك بنجاح. يمكنك الآن تسجيل الدخول.');
    }

    public function resendConfirmation(Request $request, Utilisateur $utilisateur)
    {
        $code = $this->generateConfirmationCode(8);
        $utilisateur->confirmation_code = $code;
        $utilisateur->confirmation_expires_at = now()->addHours(1);
        $utilisateur->save();

        Mail::to($utilisateur->email)->send(new AccountConfirmationMail($utilisateur));

        return redirect()->route('register.confirm.form', $utilisateur->id)
                        ->with('info', 'تم إرسال رمز جديد إلى بريدك الإلكتروني.');
    }
    
    public function loginForm() {
        return view('auth.signin');
    }

    /*public function login(Request $request) {
        $request->validate([
        'email' => 'required|email',
        'mdp'   => 'required|string',
        ], [
        'email.required' => 'الرجاء إدخال البريد الإلكتروني',
        'email.email'    => ' الرجاء إدخال بريد إلكتروني صحيح',
        'mdp.required'   => ' الرجاء إدخال كلمة المرور',
        ]);

        $user = Utilisateur::where('email', $request->email)->first();

        if (!$user || !Hash::check($request->mdp, $user->mdp)) {
            return back()->withErrors([
                'email' => ' البريد الإلكتروني أو كلمة المرور غير صحيحة',
            ]);
        }

        if (!$user->est_active) {
            return back()->withErrors([
                'email' => '⛔ حسابك غير مفعل. الرجاء الانتظار حتى يقوم المسؤول بتفعيله.',
            ]);
        }

        $remember = $request->has('remember'); 
        Auth::login($user, $remember);

        return redirect()->route('dashboard');
    }*/


    public function login(Request $request)
{
    $request->validate([
        'email' => 'required|email',
        'mdp'   => 'required|string',
    ]);

    $user = Utilisateur::where('email', $request->email)->first();

    if (!$user || !Hash::check($request->mdp, $user->mdp)) {
        return back()->withErrors(['email' => ' البريد الإلكتروني أو كلمة المرور غير صحيحة']);
    }

    if (!$user->est_active) {
        return back()->withErrors(['email' => '⛔ حسابك غير مفعل.']);
    }
    $hasRole2or3 = $user->roles()->whereIn('id_roles', [2, 3])->exists();

    if (!$hasRole2or3) {
        return back()->withErrors(['email' => '⛔ غير مسموح لك بالدخول من هذه الواجهة.']);
    }

    Auth::guard('web')->login($user, $request->has('remember'));
    if ($request->filled('redirectTo')) {
        return redirect($request->redirectTo);
    }
    return redirect()->route('dashboard');
}    

public function logout()
{
    Auth::guard('web')->logout();
    request()->session()->invalidate();
    request()->session()->regenerateToken();
    return redirect()->route('login');
}


    public function accountDetails() {
        $user = Auth::user();

        return view('auth.profil', compact('user'));
    }


   
}
